/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.webelement;

import com.tidal.utils.data.DataEnum;
import com.tidal.utils.data.GlobalData;
import dev.tidalcode.wave.actions.Interactions;
import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.Check;
import dev.tidalcode.wave.commands.Clear;
import dev.tidalcode.wave.commands.ClearAndType;
import dev.tidalcode.wave.commands.Click;
import dev.tidalcode.wave.commands.ClickByAction;
import dev.tidalcode.wave.commands.ClickByJS;
import dev.tidalcode.wave.commands.DoubleClick;
import dev.tidalcode.wave.commands.DragAndDrop;
import dev.tidalcode.wave.commands.FileUpload;
import dev.tidalcode.wave.commands.FileUploadByDragAndDrop;
import dev.tidalcode.wave.commands.FileUploadWRC;
import dev.tidalcode.wave.commands.FindTextData;
import dev.tidalcode.wave.commands.ForceClick;
import dev.tidalcode.wave.commands.GetAllAttributes;
import dev.tidalcode.wave.commands.GetAllCssAttributes;
import dev.tidalcode.wave.commands.GetAttribute;
import dev.tidalcode.wave.commands.GetCssAttribute;
import dev.tidalcode.wave.commands.GetDimension;
import dev.tidalcode.wave.commands.GetLocation;
import dev.tidalcode.wave.commands.GetRect;
import dev.tidalcode.wave.commands.GetTagName;
import dev.tidalcode.wave.commands.Hover;
import dev.tidalcode.wave.commands.IsEnabled;
import dev.tidalcode.wave.commands.IsSelected;
import dev.tidalcode.wave.commands.IsVisible;
import dev.tidalcode.wave.commands.MoveByOffSet;
import dev.tidalcode.wave.commands.MoveToElement;
import dev.tidalcode.wave.commands.PageRefresh;
import dev.tidalcode.wave.commands.PressEnter;
import dev.tidalcode.wave.commands.PressTab;
import dev.tidalcode.wave.commands.Property;
import dev.tidalcode.wave.commands.RightClick;
import dev.tidalcode.wave.commands.ScrollPage;
import dev.tidalcode.wave.commands.ScrollToView;
import dev.tidalcode.wave.commands.SelectByIndex;
import dev.tidalcode.wave.commands.SelectByText;
import dev.tidalcode.wave.commands.SelectByValue;
import dev.tidalcode.wave.commands.SendKeys;
import dev.tidalcode.wave.commands.SetInnerHtml;
import dev.tidalcode.wave.commands.SetText;
import dev.tidalcode.wave.commands.SetValue;
import dev.tidalcode.wave.commands.TableData;
import dev.tidalcode.wave.commands.UnCheck;
import dev.tidalcode.wave.data.CommandStore;
import dev.tidalcode.wave.data.IntervalTime;
import dev.tidalcode.wave.data.MaxTime;
import dev.tidalcode.wave.data.tabular.Table;
import dev.tidalcode.wave.retry.Retry;
import dev.tidalcode.wave.retry.RetryCondition;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.tabsandwindows.Frames;
import dev.tidalcode.wave.verification.conditions.Condition;
import dev.tidalcode.wave.verification.conditions.TestVerification;
import dev.tidalcode.wave.verification.criteria.Criteria;
import dev.tidalcode.wave.verification.criteria.EnsureElementState;
import dev.tidalcode.wave.verification.expectations.Expectation;
import dev.tidalcode.wave.verification.expectations.SoftAssertion;
import dev.tidalcode.wave.wait.ThreadSleep;
import dev.tidalcode.wave.wait.Wait;
import dev.tidalcode.wave.webelement.UIElement;
import dev.tidalcode.wave.webelement.UIElements;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;

public class UIActions
implements UIElement {
    private final Executor executor;
    private final List<String> locators = new LinkedList<String>();
    private boolean debugMode = false;

    public UIActions() {
        ObjectSupplier.flushInstance(this.getClass().getSimpleName());
        CommandStore.clearCommands();
        this.executor = new Executor();
        ObjectSupplier.addInstance(this.executor);
    }

    protected UIActions setProperties(String byLocator) {
        this.locators.add(byLocator);
        this.executor.usingLocator(this.locators);
        return this;
    }

    public void setMultiple() {
        boolean isMultiple = true;
        this.executor.withMultipleElements(true);
    }

    public void setElementIndex(int index) {
        this.executor.withElementIndex(index);
    }

    protected UIActions withDefaultWait() {
        Wait.setDefaultWait();
        return this;
    }

    @Override
    public UIActions invisibleElement() {
        boolean visibility = false;
        this.executor.isVisible(false);
        return this;
    }

    @Override
    public UIActions debugMode() {
        this.debugMode = true;
        this.executor.debugMode(true).invokeCommand(Property.class);
        return this;
    }

    @Override
    public UIActions click() {
        this.executor.debugMode(this.debugMode).invokeCommand(Click.class);
        return this;
    }

    @Override
    public UIActions sendKeys(CharSequence ... keysToSend) {
        Objects.requireNonNull(keysToSend, "The input value for 'SendKeys' should not be null");
        this.executor.debugMode(this.debugMode).withCharSequence(keysToSend).invokeCommand(SendKeys.class);
        return this;
    }

    @Override
    public UIActions setText(String text) {
        Objects.requireNonNull(text, "The input value for 'SetText' should not be null");
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withText(text).invokeCommand(SetText.class);
        return this;
    }

    @Override
    public UIActions setValue(String value) {
        this.executor.debugMode(this.debugMode).withText(value).invokeCommand(SetValue.class);
        return this;
    }

    @Override
    public UIActions setInnerHtml(String value) {
        this.executor.debugMode(this.debugMode).withText(value).invokeCommand(SetInnerHtml.class);
        return this;
    }

    @Override
    public UIActions clearAndType(CharSequence ... charSequences) {
        this.executor.debugMode(this.debugMode).withCharSequence(charSequences).invokeCommand(ClearAndType.class);
        return this;
    }

    @Override
    public UIActions clear() {
        this.executor.debugMode(this.debugMode).invokeCommand(Clear.class);
        return this;
    }

    @Override
    public String getAttribute(String value) {
        return (String)this.executor.debugMode(this.debugMode).withAttribute(value).invokeCommand(GetAttribute.class);
    }

    @Override
    public String getCSSAttribute(String value) {
        return (String)this.executor.debugMode(this.debugMode).withAttribute(value).invokeCommand(GetCssAttribute.class);
    }

    @Override
    public String getAllCSSAttributes() {
        return (String)this.executor.debugMode(this.debugMode).invokeCommand(GetAllCssAttributes.class);
    }

    @Override
    public Map<String, String> getAllAttributes() {
        return (Map)this.executor.debugMode(this.debugMode).invokeCommand(GetAllAttributes.class);
    }

    @Override
    public String getTagName() {
        return (String)this.executor.debugMode(this.debugMode).invokeCommand(GetTagName.class);
    }

    @Override
    public Point getLocation() {
        return (Point)this.executor.debugMode(this.debugMode).invokeCommand(GetLocation.class);
    }

    @Override
    public Rectangle getRect() {
        return (Rectangle)this.executor.debugMode(this.debugMode).invokeCommand(GetRect.class);
    }

    @Override
    public Dimension getDimension() {
        return (Dimension)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(GetDimension.class);
    }

    @Override
    public boolean isDisplayed() {
        return (Boolean)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(IsVisible.class);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(IsEnabled.class);
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(IsSelected.class);
    }

    @Override
    public String getText() {
        return (String)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(FindTextData.class);
    }

    @Override
    public UIActions check() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(Check.class);
        return this;
    }

    @Override
    public UIActions inShadowDom(String locator) {
        return null;
    }

    @Override
    public UIActions inShadowDom() {
        this.executor.debugMode(this.debugMode).presenceOfShadowDom();
        return this;
    }

    @Override
    public UIActions unCheck() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(UnCheck.class);
        return this;
    }

    @Override
    public String select(String selectValue) {
        return (String)this.executor.debugMode(this.debugMode).usingLocator(this.locators).withText(selectValue).invokeCommand(SelectByText.class);
    }

    @Override
    public String selectByValue(String selectValue) {
        return (String)this.executor.debugMode(this.debugMode).usingLocator(this.locators).withText(selectValue).invokeCommand(SelectByValue.class);
    }

    @Override
    public String select(int index) {
        return (String)this.executor.debugMode(this.debugMode).usingLocator(this.locators).withSelectIndex(index).invokeCommand(SelectByIndex.class);
    }

    @Override
    public UIActions moveToElement() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(MoveToElement.class);
        return this;
    }

    @Override
    public UIElement doubleClick() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(DoubleClick.class);
        return this;
    }

    @Override
    public UIElement rightClick() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(RightClick.class);
        return this;
    }

    @Override
    public UIElement contextClick() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(RightClick.class);
        return this;
    }

    @Override
    public UIElement actionClick() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(ClickByAction.class);
        return this;
    }

    @Override
    public UIElement forceClick() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(ForceClick.class);
        return this;
    }

    @Override
    public UIActions pressTab() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(PressTab.class);
        return this;
    }

    @Override
    @Deprecated
    public UIActions pressTab(int times) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withTabIndex(times).invokeCommand(PressTab.class);
        return this;
    }

    @Override
    public UIElement pressEnter() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(PressEnter.class);
        return this;
    }

    @Override
    public UIElement clickByJS() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(ClickByJS.class);
        return this;
    }

    @Override
    public UIActions hover(int secondsToHover) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withTimeToWait(secondsToHover).invokeCommand(Hover.class);
        return this;
    }

    @Override
    public UIActions scrollToView() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(ScrollToView.class);
        return this;
    }

    @Override
    public UIActions scrollPage(int xDirection, int yDirection) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withXYCords(xDirection, yDirection).invokeCommand(ScrollPage.class);
        return this;
    }

    @Override
    public UIActions moveByOffset(int xDirection, int yDirection) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withXYCords(xDirection, yDirection).invokeCommand(MoveByOffSet.class);
        return this;
    }

    @Override
    public UIElement dragAndDrop() {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(DragAndDrop.class);
        return this;
    }

    @Override
    public UIElement doPageRefresh(MaxTime maxTime, IntervalTime intervalTime) {
        this.executor.pageRefreshData(maxTime, intervalTime).usingLocator(this.locators).invokeCommand(PageRefresh.class);
        return this;
    }

    @Override
    public UIElement dragAndDropByOffset(int xDirection, int yDirection) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withXYCords(xDirection, yDirection).invokeCommand(DragAndDrop.class);
        return this;
    }

    @Override
    public UIActions inFrame(String locatorMatcher) {
        Frames.switchToFrame(locatorMatcher);
        return this;
    }

    @Override
    public UIActions thenFind(String locator) {
        this.locators.add(locator);
        return this;
    }

    @Override
    public UIElements thenFindAll(String newLocator) {
        this.locators.add(newLocator);
        UIElements uiElements = new UIElements();
        uiElements.setElementProperties(this);
        return uiElements;
    }

    @Override
    public UIActions waitFor(int waitTime) {
        Wait.setExplicitWait(waitTime);
        return this;
    }

    @Override
    public void retryIf(Supplier<RetryCondition> retryCondition) {
        Retry.retry(this.executor, retryCondition.get(), 1);
    }

    @Override
    public void retryIf(RetryCondition retryCondition) {
        Retry.retry(this.executor, retryCondition, 1);
    }

    @Override
    public void retryIf(Supplier<RetryCondition> retryCondition, int numberOfTimes) {
        Retry.retry(this.executor, retryCondition.get(), numberOfTimes);
    }

    @Override
    public void retryIf(RetryCondition retryCondition, int numberOfTimes) {
        Retry.retry(this.executor, retryCondition, numberOfTimes);
    }

    @Override
    public Expectation expecting(Expectation expectation) {
        return SoftAssertion.softAssert(this.executor, expectation);
    }

    @Override
    public Expectation expecting(Supplier<Expectation> expectation) {
        return SoftAssertion.softAssert(this.executor, expectation.get());
    }

    @Override
    public void shouldHave(Condition ... condition) {
        TestVerification.verification(this.executor, condition);
    }

    @Override
    public final UIActions shouldBe(Criteria ... criteria) {
        EnsureElementState.affirmation(this.executor, criteria);
        return this;
    }

    @Override
    public final UIActions shouldBe(Supplier<Criteria> criteria) {
        Supplier[] criterion = new Supplier[]{criteria};
        EnsureElementState.affirmation(this.executor, criterion);
        return this;
    }

    @Override
    public final UIActions shouldBe(Supplier<Criteria> criteria1, Supplier<Criteria> criteria2) {
        Supplier[] criterion = new Supplier[]{criteria1, criteria2};
        EnsureElementState.affirmation(this.executor, new Criteria[0]);
        return this;
    }

    @Override
    public UIActions addData(String key) {
        GlobalData.addData((String)key, (String)((String)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(FindTextData.class, "findTextData")));
        return this;
    }

    @Override
    public UIActions addData(DataEnum key) {
        GlobalData.addData((DataEnum)key, (String)((String)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(FindTextData.class, "findTextData")));
        return this;
    }

    @Override
    public void addData(String key, String value) {
        GlobalData.addData((String)key, (String)value);
    }

    @Override
    public UIElement uploadFile(@NotNull String fileName) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withText(fileName).invokeCommand(FileUpload.class);
        return this;
    }

    @Override
    public UIElement uploadFileWRC(@NotNull String fileName) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withText(fileName).invokeCommand(FileUploadWRC.class);
        return this;
    }

    @Override
    public UIElement uploadFileByDragAndDrop(@NotNull String fileName) {
        this.executor.debugMode(this.debugMode).usingLocator(this.locators).withText(fileName).invokeCommand(FileUploadByDragAndDrop.class);
        return this;
    }

    @Override
    public UIActions pause(int seconds) {
        ThreadSleep.forSeconds(seconds);
        return this;
    }

    @Override
    public Table tableData() {
        return (Table)this.executor.debugMode(this.debugMode).usingLocator(this.locators).invokeCommand(TableData.class);
    }

    @Override
    public void performActions(Interactions interactions) {
        interactions.build();
    }

    protected List<String> getLocators() {
        return this.locators;
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

