/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.engine;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import dev.voidframework.cache.engine.CacheEngine;
import dev.voidframework.core.bindable.BindClass;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@BindClass
public final class MemoryCacheEngine
implements CacheEngine {
    private final int flushWhenFullMaxItem;
    private final Map<String, CachedItem> cacheMap;

    @Inject
    public MemoryCacheEngine(Config configuration) {
        this.flushWhenFullMaxItem = configuration.getInt("voidframework.cache.inMemory.flushWhenFullMaxItem");
        this.cacheMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public Object get(String cacheKey) {
        if (StringUtils.isBlank((CharSequence)cacheKey)) {
            return null;
        }
        CachedItem cachedItem = this.cacheMap.get(cacheKey);
        if (cachedItem == null) {
            return null;
        }
        if (LocalDateTime.now(ZoneOffset.UTC).isAfter(cachedItem.expirationDate)) {
            this.cacheMap.remove(cacheKey);
            return null;
        }
        return cachedItem.value;
    }

    @Override
    public void set(String cacheKey, Object value, int timeToLive) {
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            if (this.cacheMap.size() >= this.flushWhenFullMaxItem) {
                this.cacheMap.clear();
            }
            CachedItem cachedItem = new CachedItem(value, timeToLive > 0 ? LocalDateTime.now(ZoneOffset.UTC).plusSeconds(timeToLive) : LocalDateTime.MAX);
            this.cacheMap.put(cacheKey, cachedItem);
        }
    }

    private record CachedItem(Object value, LocalDateTime expirationDate) {
    }
}

