/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.module;

import com.google.inject.Inject;
import dev.voidframework.cache.Cache;
import dev.voidframework.cache.engine.BlackHoleCacheEngine;
import dev.voidframework.cache.engine.CacheEngine;
import dev.voidframework.core.helper.ProxyDetector;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class CacheInterceptor
implements MethodInterceptor {
    private CacheEngine cacheEngine = null;

    @Inject
    public void setCacheEngine(CacheEngine cacheEngine) {
        if (!(cacheEngine instanceof BlackHoleCacheEngine)) {
            this.cacheEngine = cacheEngine;
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String cacheKey;
        if (this.cacheEngine == null) {
            return methodInvocation.proceed();
        }
        Cache cache = methodInvocation.getMethod().getAnnotation(Cache.class);
        if (cache.key().contains("{")) {
            String className = ProxyDetector.isProxy((Object)methodInvocation.getThis()) ? methodInvocation.getThis().getClass().getSuperclass().getName() : methodInvocation.getThis().getClass().getName();
            String methodName = methodInvocation.getMethod().getName();
            cacheKey = cache.key().replace("{class}", className).replace("{method}", methodName);
        } else {
            cacheKey = cache.key();
        }
        Object value = this.cacheEngine.get(cacheKey);
        if (value == null) {
            value = methodInvocation.proceed();
            this.cacheEngine.set(cacheKey, value, cache.timeToLive());
        }
        return value;
    }
}

