/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.engine;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dev.voidframework.cache.engine.CacheEngine;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class AbstractCacheEngine
implements CacheEngine {
    private final Kryo kryo = new Kryo();

    public AbstractCacheEngine() {
        this.kryo.setRegistrationRequired(false);
        this.kryo.register(ArrayList.class);
        this.kryo.register(HashMap.class);
        this.kryo.register(HashSet.class);
        this.kryo.register(Class.class);
    }

    public CachedElement wrap(Object obj) {
        Output output = new Output((OutputStream)new ByteBufferOutputStream());
        Class classType = obj != null ? obj.getClass() : Object.class;
        this.kryo.writeObjectOrNull(output, obj, classType);
        return new CachedElement(classType, output.toBytes());
    }

    public Object unwrap(CachedElement cachedElement) {
        if (cachedElement == null) {
            return null;
        }
        Input input = new Input(cachedElement.content);
        return this.kryo.readObjectOrNull(input, cachedElement.classType);
    }

    protected record CachedElement(Class<?> classType, byte[] content) {
    }
}

