/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.module;

import com.google.inject.Inject;
import dev.voidframework.cache.engine.BlackHoleCacheEngine;
import dev.voidframework.cache.engine.CacheEngine;
import dev.voidframework.core.helper.ProxyDetector;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class CacheInterceptor
implements MethodInterceptor {
    protected CacheEngine cacheEngine = null;

    @Inject
    public void setCacheEngine(CacheEngine cacheEngine) {
        if (!(cacheEngine instanceof BlackHoleCacheEngine)) {
            this.cacheEngine = cacheEngine;
        }
    }

    protected String resolveCacheKey(MethodInvocation methodInvocation, String keyPattern) {
        String cacheKey = keyPattern;
        if (cacheKey.isEmpty()) {
            cacheKey = "{class}.{method}";
        }
        if (cacheKey.contains("{")) {
            String className = ProxyDetector.isProxy((Object)methodInvocation.getThis()) ? methodInvocation.getThis().getClass().getSuperclass().getName() : methodInvocation.getThis().getClass().getName();
            String methodName = methodInvocation.getMethod().getName();
            cacheKey = keyPattern.replace("{class}", className).replace("{method}", methodName);
            Object[] argumentArray = methodInvocation.getArguments();
            for (int idx = 0; idx < argumentArray.length; ++idx) {
                cacheKey = argumentArray[idx] == null ? cacheKey.replace("{" + idx + "}", "null") : cacheKey.replace("{" + idx + "}", argumentArray[idx].toString());
            }
        }
        return cacheKey;
    }
}

