/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.engine;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import dev.voidframework.cache.engine.AbstractCacheEngine;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class MemoryCacheEngine
extends AbstractCacheEngine {
    private final int flushWhenFullMaxItem;
    private final Map<String, ExpirationElement> cacheMap;

    @Inject
    public MemoryCacheEngine(Config configuration) {
        this.flushWhenFullMaxItem = configuration.getInt("voidframework.cache.inMemory.flushWhenFullMaxItem");
        this.cacheMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public Object get(String cacheKey) {
        if (StringUtils.isBlank((CharSequence)cacheKey)) {
            return null;
        }
        ExpirationElement expirationElement = this.cacheMap.get(cacheKey);
        if (expirationElement == null) {
            return null;
        }
        if (LocalDateTime.now(ZoneOffset.UTC).isAfter(expirationElement.expirationDate)) {
            this.cacheMap.remove(cacheKey);
            return null;
        }
        return this.unwrap(expirationElement.cachedElement);
    }

    @Override
    public void set(String cacheKey, Object value, int timeToLive) {
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            if (this.cacheMap.size() >= this.flushWhenFullMaxItem) {
                this.cacheMap.clear();
            }
            ExpirationElement expirationElement = new ExpirationElement(this.wrap(value), timeToLive > 0 ? LocalDateTime.now(ZoneOffset.UTC).plusSeconds(timeToLive) : LocalDateTime.MAX);
            this.cacheMap.put(cacheKey, expirationElement);
        }
    }

    @Override
    public void remove(String cacheKey) {
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            this.cacheMap.remove(cacheKey);
        }
    }

    private record ExpirationElement(AbstractCacheEngine.CachedElement cachedElement, LocalDateTime expirationDate) {
    }
}

