/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.datasource;

import com.google.inject.Provider;
import com.typesafe.config.Config;
import dev.voidframework.datasource.DataSourceManager;
import dev.voidframework.exception.DataSourceException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractDataSourceProvider
implements Provider<DataSourceManager> {
    protected static final String PREFIX_CONFIGURATION_KEY_DATASOURCE = "voidframework.datasource.";
    private static final String CONFIGURATION_KEY_DATASOURCE = "voidframework.datasource";

    protected Set<String> retrieveDataSourceConfigurationNames(Config configuration) {
        Set<String> dbConfigurationNameSet = configuration.getConfig(CONFIGURATION_KEY_DATASOURCE).entrySet().stream().map(Map.Entry::getKey).map(key -> {
            if (key.contains(".")) {
                return key.substring(0, key.indexOf("."));
            }
            return key;
        }).collect(Collectors.toSet());
        if (dbConfigurationNameSet.isEmpty()) {
            throw new DataSourceException.NotConfigured();
        }
        return dbConfigurationNameSet;
    }
}

