/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.datasource.utils;

import com.typesafe.config.Config;
import dev.voidframework.datasource.exception.DataSourceException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class DataSourceUtils {
    private DataSourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Set<String> getAllDataSourceNames(Config configuration) {
        if (!configuration.hasPathOrNull("voidframework.datasource")) {
            throw new DataSourceException.NotConfigured();
        }
        return configuration.getConfig("voidframework.datasource").entrySet().stream().map(Map.Entry::getKey).map(key -> {
            if (key.contains(".")) {
                return key.substring(0, key.indexOf("."));
            }
            return key;
        }).collect(Collectors.toSet());
    }
}

