/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.migration.flyway;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.typesafe.config.Config;
import dev.voidframework.core.bindable.BindClass;
import dev.voidframework.core.lifecycle.LifeCycleStart;
import dev.voidframework.datasource.DataSourceManager;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.output.MigrateResult;

@BindClass
public final class FlywayMigration {
    private final Config configuration;
    private final Provider<DataSourceManager> dataSourceManagerProvider;

    @Inject
    public FlywayMigration(Config configuration, Provider<DataSourceManager> dataSourceManagerProvider) {
        this.configuration = configuration;
        this.dataSourceManagerProvider = dataSourceManagerProvider;
    }

    @LifeCycleStart(priority=50)
    public void migrate() {
        List<String> scriptLocationList = this.configuration.getStringList("voidframework.migration.flyway.scriptLocations").stream().filter(StringUtils::isNotEmpty).toList();
        List<String> callbackList = this.configuration.getStringList("voidframework.migration.flyway.callbacks").stream().filter(StringUtils::isNotEmpty).toList();
        if (!scriptLocationList.isEmpty()) {
            DataSource dataSource = ((DataSourceManager)this.dataSourceManagerProvider.get()).getDataSource();
            Flyway flyway = Flyway.configure().callbacks(callbackList.toArray(new String[0])).dataSource(dataSource).encoding(StandardCharsets.UTF_8).locations(scriptLocationList.toArray(new String[0])).outOfOrder(this.configuration.getBoolean("voidframework.migration.flyway.outOfOrder")).placeholderReplacement(this.configuration.getBoolean("voidframework.migration.flyway.placeholderReplacement")).table(this.configuration.getString("voidframework.migration.flyway.historySchemaTable")).tablespace(this.configuration.getString("voidframework.migration.flyway.historySchemaTablespace")).load();
            MigrateResult result = flyway.migrate();
            if (result.migrationsExecuted > 0) {
                flyway.validate();
            }
        }
    }
}

