/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.scheduler.module;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import dev.voidframework.scheduler.Scheduled;
import dev.voidframework.scheduler.module.ScheduledHandlers;
import java.lang.reflect.Method;

public class SchedulerAnnotationListener
implements TypeListener {
    private final ScheduledHandlers scheduledHandlers;

    public SchedulerAnnotationListener(ScheduledHandlers scheduledHandlers) {
        this.scheduledHandlers = scheduledHandlers;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class classType = type.getRawType();
        for (Method method : classType.getDeclaredMethods()) {
            Scheduled scheduled = method.getAnnotation(Scheduled.class);
            if (scheduled == null) continue;
            this.scheduledHandlers.add(new ScheduledHandlers.ScheduledHandler(classType, method, scheduled));
        }
    }
}

