/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.scheduler.cron;

import dev.voidframework.scheduler.cron.CronExpressionPartStepValue;
import dev.voidframework.scheduler.exception.SchedulerException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class CronExpressionPartList
extends CronExpressionPartStepValue {
    private final List<Integer> lst;

    public CronExpressionPartList(int stepValue, List<Integer> lst) {
        super(stepValue);
        this.lst = lst != null ? lst : Collections.emptyList();
    }

    @Override
    public boolean isNotCompliant(int value) {
        return super.isNotCompliant(value) ^ this.lst.contains(value);
    }

    @Override
    public void assertViolation(int allowedMinStepValue, int allowedMaxStepValue, int allowedMinValue, int allowedMaxValue) {
        super.assertViolation(allowedMinStepValue, allowedMaxStepValue, allowedMinValue, allowedMaxValue);
        if (this.lst.stream().anyMatch(value -> value < allowedMinValue || value > allowedMaxValue)) {
            throw new SchedulerException.InvalidCronExpression("List '%s' is invalid. All values must be between '%s..%s'.", Arrays.toString(this.lst.toArray()), allowedMinValue, allowedMaxValue);
        }
    }
}

