/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.scheduler.cron;

import dev.voidframework.scheduler.cron.CronExpressionPart;
import dev.voidframework.scheduler.cron.CronExpressionPartList;
import dev.voidframework.scheduler.cron.CronExpressionPartRange;
import dev.voidframework.scheduler.cron.CronExpressionPartStepValue;
import dev.voidframework.scheduler.exception.SchedulerException;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CronExpression {
    private static final Pattern REGEXP_PATTERN_RANGE = Pattern.compile("^([^-]+)-([^-/]+)(/(\\d+))?$");
    private static final Pattern REGEXP_PATTERN_LIST = Pattern.compile("^([^-/]+)(/(\\d+))?$");
    private static final Pattern REGEXP_PATTERN_SINGLE = Pattern.compile("^(\\d+)(/(\\d+))?$");
    private static final List<String> WILDCARD_REPLACEMENT = List.of("0-59", "0-59", "0-23", "1-31", "1-12", "0-6");
    private static final List<Consumer<CronExpressionPart>> CRON_EXPRESSION_PART_VALIDATOR = List.of(c -> c.assertViolation(1, 60, 0, 59), c -> c.assertViolation(1, 60, 0, 59), c -> c.assertViolation(1, 24, 0, 23), c -> c.assertViolation(1, 32, 1, 31), c -> c.assertViolation(1, 13, 1, 12), c -> c.assertViolation(1, 7, 0, 6));
    private static final int IDX_SECOND = 0;
    private static final int IDX_MINUTE = 1;
    private static final int IDX_HOUR = 2;
    private static final int IDX_DAY_OF_MONTH = 3;
    private static final int IDX_MONTH = 4;
    private static final int IDX_DAY_OF_WEEK = 5;
    private static final Map<String, String> MONTH_NAME_TO_VALUE = Map.ofEntries(Map.entry("JAN", "1"), Map.entry("FEB", "2"), Map.entry("MAR", "3"), Map.entry("APR", "4"), Map.entry("MAY", "5"), Map.entry("JUN", "6"), Map.entry("JUL", "7"), Map.entry("AUG", "8"), Map.entry("SEP", "9"), Map.entry("OCT", "10"), Map.entry("NOV", "11"), Map.entry("DEC", "12"));
    private static final Map<String, String> DAY_OF_WEEK_NAME_TO_VALUE = Map.ofEntries(Map.entry("SUN", "0"), Map.entry("MON", "1"), Map.entry("TUE", "2"), Map.entry("WED", "3"), Map.entry("THU", "4"), Map.entry("FRI", "5"), Map.entry("SAT", "6"));
    private static final Map<DayOfWeek, Integer> DAY_OF_WEEK_CRON_VALUE = Map.ofEntries(Map.entry(DayOfWeek.SUNDAY, 0), Map.entry(DayOfWeek.MONDAY, 1), Map.entry(DayOfWeek.TUESDAY, 2), Map.entry(DayOfWeek.WEDNESDAY, 3), Map.entry(DayOfWeek.THURSDAY, 4), Map.entry(DayOfWeek.FRIDAY, 5), Map.entry(DayOfWeek.SATURDAY, 6));
    private final CronExpressionPart[] cronExpressionPartArray;

    public CronExpression(String cron) {
        String[] cronArray = cron.toUpperCase(Locale.ENGLISH).split(" ");
        if (cronArray.length < 5) {
            throw new SchedulerException.InvalidCronExpression("CRON expression is invalid '%s'", cron);
        }
        for (Map.Entry<String, String> entrySet : DAY_OF_WEEK_NAME_TO_VALUE.entrySet()) {
            cronArray[5] = cronArray[5].replace(entrySet.getKey(), entrySet.getValue());
        }
        for (Map.Entry<String, String> entrySet : MONTH_NAME_TO_VALUE.entrySet()) {
            cronArray[4] = cronArray[4].replace(entrySet.getKey(), entrySet.getValue());
        }
        this.cronExpressionPartArray = new CronExpressionPart[6];
        for (int idx = 0; idx < this.cronExpressionPartArray.length; ++idx) {
            String standardizedPart = cronArray[idx].replace("?", "*").replace("*", WILDCARD_REPLACEMENT.get(idx));
            try {
                this.cronExpressionPartArray[idx] = this.parseCronExpressionPart(standardizedPart);
                if (idx >= CRON_EXPRESSION_PART_VALIDATOR.size()) continue;
                CRON_EXPRESSION_PART_VALIDATOR.get(idx).accept(this.cronExpressionPartArray[idx]);
                continue;
            }
            catch (SchedulerException.InvalidCronExpression ex) {
                throw new SchedulerException.InvalidCronExpression(ex, "Can't use CRON '%s', error with the part #%d '%s'", cron, idx + 1, cronArray[idx]);
            }
        }
    }

    public long getNextDelayMilliseconds(ZoneId zoneId) {
        return this.getNextDelayMilliseconds(LocalDateTime.now(zoneId));
    }

    private long getNextDelayMilliseconds(LocalDateTime from) {
        LocalDateTime nextTrigger = from.plusSeconds(1L);
        CronExpressionPart cronExpressionPart = this.cronExpressionPartArray[0];
        while (cronExpressionPart.isNotCompliant(nextTrigger.getSecond())) {
            nextTrigger = nextTrigger.plusSeconds(1L);
        }
        cronExpressionPart = this.cronExpressionPartArray[1];
        while (cronExpressionPart.isNotCompliant(nextTrigger.getMinute())) {
            nextTrigger = nextTrigger.plusMinutes(1L);
        }
        cronExpressionPart = this.cronExpressionPartArray[2];
        while (cronExpressionPart.isNotCompliant(nextTrigger.getHour())) {
            nextTrigger = nextTrigger.plusHours(1L);
        }
        cronExpressionPart = this.cronExpressionPartArray[3];
        while (cronExpressionPart.isNotCompliant(nextTrigger.getDayOfMonth())) {
            nextTrigger = nextTrigger.plusDays(1L);
        }
        cronExpressionPart = this.cronExpressionPartArray[4];
        while (cronExpressionPart.isNotCompliant(nextTrigger.getMonthValue())) {
            nextTrigger = nextTrigger.plusMonths(1L);
        }
        cronExpressionPart = this.cronExpressionPartArray[5];
        while (cronExpressionPart.isNotCompliant(DAY_OF_WEEK_CRON_VALUE.get(nextTrigger.getDayOfWeek()))) {
            nextTrigger = nextTrigger.plusDays(1L);
        }
        int millisecondsToRemove = from.get(ChronoField.MILLI_OF_SECOND);
        return ChronoUnit.MILLIS.between(from.truncatedTo(ChronoUnit.MILLIS), nextTrigger.minus(millisecondsToRemove, ChronoUnit.MILLIS));
    }

    private CronExpressionPart parseCronExpressionPart(String str) {
        CronExpressionPartStepValue cronExpressionPart = null;
        if (str.contains("-")) {
            Matcher matcher = REGEXP_PATTERN_RANGE.matcher(str);
            if (matcher.find()) {
                int minRange = matcher.group(1) != null ? Integer.parseInt(matcher.group(1)) : 0;
                int maxRange = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : minRange;
                int stepValue = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : -1;
                cronExpressionPart = new CronExpressionPartRange(stepValue, minRange, maxRange);
            }
        } else if (str.contains(",")) {
            Matcher matcher = REGEXP_PATTERN_LIST.matcher(str);
            if (matcher.find()) {
                String listValue = matcher.group(1);
                int stepValue = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : -1;
                cronExpressionPart = new CronExpressionPartList(stepValue, Arrays.stream(listValue.split(",")).map(Integer::parseInt).toList());
            }
        } else {
            Matcher matcher = REGEXP_PATTERN_SINGLE.matcher(str);
            if (matcher.find()) {
                int singleValue = Integer.parseInt(matcher.group(1));
                int stepValue = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : -1;
                cronExpressionPart = new CronExpressionPartRange(stepValue, singleValue, singleValue);
            }
        }
        if (cronExpressionPart == null) {
            throw new SchedulerException.InvalidCronExpression("Can't parse CRON expression part: %s", str);
        }
        return cronExpressionPart;
    }
}

