/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.scheduler.cron;

import dev.voidframework.scheduler.cron.CronExpressionPartStepValue;
import dev.voidframework.scheduler.exception.SchedulerException;

class CronExpressionPartRange
extends CronExpressionPartStepValue {
    private final int min;
    private final int max;

    public CronExpressionPartRange(int stepValue, int min, int max) {
        super(stepValue);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isNotCompliant(int value) {
        return super.isNotCompliant(value) ^ (value >= this.min && value <= this.max);
    }

    @Override
    public void assertViolation(int allowedMinStepValue, int allowedMaxStepValue, int allowedMinValue, int allowedMaxValue) {
        super.assertViolation(allowedMinStepValue, allowedMaxStepValue, allowedMinValue, allowedMaxValue);
        if (this.min < allowedMinValue || this.max > allowedMaxValue) {
            throw new SchedulerException.InvalidCronExpression("Range value '%s..%s' is invalid. Allowed Range is '%s..%s'.", this.min, this.max, allowedMinValue, allowedMaxValue);
        }
        if (this.min > this.max) {
            throw new SchedulerException.InvalidCronExpression("Min value '%s' can't be higher than Max value '%s'", this.min, this.max);
        }
    }
}

