/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.scheduler.cron;

import dev.voidframework.scheduler.cron.CronExpressionPart;
import dev.voidframework.scheduler.exception.SchedulerException;

class CronExpressionPartStepValue
implements CronExpressionPart {
    private final int stepValue;

    protected CronExpressionPartStepValue(int stepValue) {
        this.stepValue = stepValue;
    }

    @Override
    public boolean isNotCompliant(int value) {
        return this.stepValue == -1 || value % this.stepValue == 0;
    }

    @Override
    public void assertViolation(int allowedMinStepValue, int allowedMaxStepValue, int allowedMinValue, int allowedMaxValue) {
        if (this.stepValue != -1 && (this.stepValue < allowedMinStepValue || this.stepValue > allowedMaxStepValue)) {
            throw new SchedulerException.InvalidCronExpression("Step value '%s' is invalid. It must be between '%s..%s'.", this.stepValue, allowedMaxStepValue, allowedMinStepValue);
        }
    }
}

