/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.scheduler.exception;

public class SchedulerException
extends RuntimeException {
    protected SchedulerException(String message) {
        this(message, null);
    }

    protected SchedulerException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class InvalidCronExpression
    extends SchedulerException {
        public InvalidCronExpression(String errorMessage, Object ... stringFormatArgs) {
            super(String.format(errorMessage, stringFormatArgs));
        }

        public InvalidCronExpression(InvalidCronExpression causeException, String errorMessage, Object ... stringFormatArgs) {
            super(String.format(errorMessage, stringFormatArgs), causeException);
        }
    }

    public static class InvalidInitialDelay
    extends SchedulerException {
        public InvalidInitialDelay(int initialDelay) {
            super("The initial delay %d is invalid".formatted(initialDelay));
        }
    }

    public static class InvalidFixedRate
    extends SchedulerException {
        public InvalidFixedRate(int fixedRate) {
            super("Value fixedRate %d is invalid".formatted(fixedRate));
        }
    }

    public static class InvalidFixedDelay
    extends SchedulerException {
        public InvalidFixedDelay(int fixedRate) {
            super("Value fixedDelay %d is invalid".formatted(fixedRate));
        }
    }

    public static class FixedDelayAndRateAreExclusive
    extends SchedulerException {
        public FixedDelayAndRateAreExclusive() {
            super("Values fixedDelay and fixedRate are mutually exclusive");
        }
    }
}

