/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.validation;

import com.google.inject.Singleton;
import dev.voidframework.core.bindable.Service;
import dev.voidframework.validation.Validated;
import dev.voidframework.validation.ValidationError;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Service
@Singleton
public final class Validation {
    private static final List<String> SORTED_ARGUMENT_TO_EXTRACT_LIST = List.of("value", "min", "max", "integer", "years", "months", "days", "hours", "minutes", "seconds", "millis", "nanos", "inclusive");
    private final Map<Locale, Validator> validatorPerLocaleMap = new ConcurrentHashMap<Locale, Validator>();

    public <T> Validated<T> validate(T objectToValidate) {
        return this.validate(objectToValidate, Locale.getDefault(), new Class[0]);
    }

    public <T> Validated<T> validate(T objectToValidate, Locale locale, Class<?> ... constraintGroupArray) {
        HashMap<String, List<ValidationError>> validationErrorPerKeyMap = new HashMap<String, List<ValidationError>>();
        if (objectToValidate == null) {
            return new Validated<Object>(null, validationErrorPerKeyMap);
        }
        Validator validator = this.validatorPerLocaleMap.computeIfAbsent(locale, this::createValidator);
        Set constraintViolationSet = validator.validate(objectToValidate, (Class[])constraintGroupArray);
        constraintViolationSet.stream().sorted(Comparator.comparing(ConstraintViolation::getMessageTemplate)).forEach(constraintViolation -> {
            String fieldKey = constraintViolation.getPropertyPath().toString();
            List validationErrorList = validationErrorPerKeyMap.computeIfAbsent(fieldKey, key -> new ArrayList());
            validationErrorList.add(new ValidationError(constraintViolation.getMessage(), constraintViolation.getMessageTemplate().replaceAll("[{}]", ""), this.createMessageArgumentArray((ConstraintViolation<?>)constraintViolation)));
        });
        return new Validated<T>(objectToValidate, validationErrorPerKeyMap);
    }

    private Object[] createMessageArgumentArray(ConstraintViolation<?> constraintViolation) {
        Map attributeMap = constraintViolation.getConstraintDescriptor().getAttributes();
        return SORTED_ARGUMENT_TO_EXTRACT_LIST.stream().filter(attributeMap::containsKey).map(attributeMap::get).toArray();
    }

    private Validator createValidator(Locale locale) {
        Configuration configuration = jakarta.validation.Validation.byDefaultProvider().configure();
        configuration = configuration.messageInterpolator((MessageInterpolator)new MessageInterpolatorWithLocale(configuration.getDefaultMessageInterpolator(), locale));
        try (ValidatorFactory validatorFactory = configuration.buildValidatorFactory();){
            Validator validator = validatorFactory.getValidator();
            return validator;
        }
    }

    private record MessageInterpolatorWithLocale(MessageInterpolator delegate, Locale locale) implements MessageInterpolator
    {
        public String interpolate(String message, MessageInterpolator.Context context) {
            return this.delegate.interpolate(message, context, this.locale);
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(message, context, locale);
        }
    }
}

