/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.vfs.engine;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import dev.voidframework.vfs.engine.VirtualFileStorage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskVirtualFileStorage
implements VirtualFileStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskVirtualFileStorage.class);
    private final Path basePath;

    @Inject
    public DiskVirtualFileStorage(Config configuration) {
        String storageDirectory = configuration.hasPath("basePath") ? configuration.getString("basePath") : System.getProperty("java.io.tmpdir");
        this.basePath = Paths.get(storageDirectory, new String[0]);
    }

    @Override
    public InputStream retrieveFile(String fileName) {
        Path filePath = this.basePath.resolve(fileName);
        try {
            return Files.newInputStream(filePath, StandardOpenOption.READ);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    @Override
    public boolean storeFile(String fileName, String contentType, InputStream contentStream) {
        if (contentStream == null) {
            return false;
        }
        Path filePath = this.basePath.resolve(fileName);
        try {
            try (FileOutputStream outStream = new FileOutputStream(filePath.toFile());){
                int nbReadBytes;
                byte[] buffer = new byte[8192];
                while ((nbReadBytes = contentStream.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, nbReadBytes);
                }
                outStream.flush();
            }
            return true;
        }
        catch (IOException exception) {
            LOGGER.error("Can't store file %s (%s)".formatted(fileName, contentType), (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean storeFile(String fileName, String contentType, InputStream contentStream, Properties properties) {
        return this.storeFile(fileName, contentType, contentStream);
    }

    @Override
    public boolean deleteFile(String fileName) {
        Path filePath = this.basePath.resolve(fileName);
        try {
            Files.delete(filePath);
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }
}

