/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.vfs.engine;

import dev.voidframework.vfs.engine.VirtualFileStorage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryVirtualFileStorage
implements VirtualFileStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryVirtualFileStorage.class);
    private final Map<String, byte[]> storage = new ConcurrentHashMap<String, byte[]>();

    @Override
    public InputStream retrieveFile(String fileName) {
        byte[] fileContent = this.storage.getOrDefault(fileName, null);
        if (fileContent == null) {
            return null;
        }
        return new ByteArrayInputStream(fileContent);
    }

    @Override
    public boolean storeFile(String fileName, String contentType, InputStream contentStream) {
        if (contentStream == null) {
            return false;
        }
        try {
            byte[] fileContent = contentStream.readAllBytes();
            this.storage.put(fileName, fileContent);
            return true;
        }
        catch (IOException exception) {
            LOGGER.error("Can't store file %s (%s)".formatted(fileName, contentType), (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean storeFile(String fileName, String contentType, InputStream contentStream, Properties properties) {
        return this.storeFile(fileName, contentType, contentStream);
    }

    @Override
    public boolean deleteFile(String fileName) {
        return this.storage.remove(fileName) != null;
    }
}

