/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.vfs.exception;

public class VirtualFileStorageException
extends RuntimeException {
    protected VirtualFileStorageException(String message) {
        this(message, null);
    }

    protected VirtualFileStorageException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class CantInstantiateEngine
    extends VirtualFileStorageException {
        public CantInstantiateEngine() {
            super("Virtual File Storage can't be instantiated. It must have a public empty constructor or a public constructor with Config parameter");
        }
    }

    public static class NotConfigured
    extends VirtualFileStorageException {
        public NotConfigured() {
            super("Virtual File Storage is not configured");
        }
    }

    public static class EngineNotFound
    extends VirtualFileStorageException {
        public EngineNotFound(String engineClassPath) {
            super("Virtual File Storage engine '" + engineClassPath + "' not found");
        }
    }
}

