/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.vfs.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import dev.voidframework.core.utils.ClassResolverUtils;
import dev.voidframework.vfs.engine.VirtualFileStorage;
import dev.voidframework.vfs.exception.VirtualFileStorageException;
import dev.voidframework.vfs.module.VirtualFileStorageProvider;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class VirtualFileStorageModule
extends AbstractModule {
    private final Config configuration;

    public VirtualFileStorageModule(Config configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        Set vfsConfigurationNameSet = this.configuration.getConfig("voidframework.vfs").entrySet().stream().map(Map.Entry::getKey).map(key -> {
            if (key.contains(".")) {
                return key.substring(0, key.indexOf("."));
            }
            return key;
        }).collect(Collectors.toSet());
        if (vfsConfigurationNameSet.isEmpty()) {
            throw new VirtualFileStorageException.NotConfigured();
        }
        for (String vfsConfigurationName : vfsConfigurationNameSet) {
            Config engineConfiguration = this.configuration.getConfig("voidframework.vfs." + vfsConfigurationName);
            String engineClassName = engineConfiguration.getString("className");
            boolean useAsDefault = engineConfiguration.getBoolean("default");
            Class classType = ClassResolverUtils.forName((String)engineClassName);
            if (classType == null) {
                throw new VirtualFileStorageException.EngineNotFound(engineClassName);
            }
            VirtualFileStorageProvider provider = new VirtualFileStorageProvider(classType, engineConfiguration);
            this.bind(VirtualFileStorage.class).annotatedWith((Annotation)Names.named((String)vfsConfigurationName)).toProvider((Provider)provider);
            if (!useAsDefault) continue;
            this.bind(VirtualFileStorage.class).toProvider((Provider)provider);
        }
    }
}

