/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.vfs.module;

import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.vfs.engine.VirtualFileStorage;
import dev.voidframework.vfs.exception.VirtualFileStorageException;
import java.lang.reflect.InvocationTargetException;

@Singleton
public class VirtualFileStorageProvider
implements Provider<VirtualFileStorage> {
    private final Class<? extends VirtualFileStorage> classType;
    private final Config vfsEngineConfiguration;
    private VirtualFileStorage currentInstance;

    public VirtualFileStorageProvider(Class<? extends VirtualFileStorage> classType, Config vfsEngineConfiguration) {
        this.classType = classType;
        this.vfsEngineConfiguration = vfsEngineConfiguration;
        this.currentInstance = null;
    }

    public VirtualFileStorage get() {
        if (this.currentInstance == null) {
            try {
                this.instantiateVirtualFileStorage();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ignore) {
                throw new VirtualFileStorageException.CantInstantiateEngine();
            }
        }
        return this.currentInstance;
    }

    private void instantiateVirtualFileStorage() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        try {
            this.currentInstance = this.classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ignore) {
            this.currentInstance = this.classType.getDeclaredConstructor(Config.class).newInstance(this.vfsEngineConfiguration);
        }
    }
}

