/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.filter;

import dev.voidframework.web.exception.FilterException;
import dev.voidframework.web.filter.Filter;
import dev.voidframework.web.filter.FilterChain;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.Result;
import java.util.List;

public final class DefaultFilterChain
implements FilterChain {
    private final List<Filter> filterList;
    private int currentFilterIndex;

    public DefaultFilterChain(List<Filter> filterList) {
        this.filterList = filterList;
        this.currentFilterIndex = -1;
    }

    @Override
    public Result applyNext(Context context) {
        if (this.currentFilterIndex < this.filterList.size()) {
            ++this.currentFilterIndex;
            return this.filterList.get(this.currentFilterIndex).apply(context, this);
        }
        throw new FilterException.Overflow(this.currentFilterIndex, this.filterList.size());
    }
}

