/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import com.google.inject.Injector;
import com.typesafe.config.Config;
import dev.voidframework.core.conversion.Conversion;
import dev.voidframework.template.TemplateRenderer;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.filter.DefaultFilterChain;
import dev.voidframework.web.filter.Filter;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.ErrorHandler;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.param.RequestBody;
import dev.voidframework.web.http.param.RequestPath;
import dev.voidframework.web.http.param.RequestVariable;
import dev.voidframework.web.routing.ResolvedRoute;
import dev.voidframework.web.routing.Router;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HttpRequestHandler {
    private static final Map<Class<?>, PrimitiveAlternative> PRIMITIVE_ALTERNATIVE_MAP = new HashMap<Class<?>, PrimitiveAlternative>(){
        {
            this.put(Boolean.TYPE, new PrimitiveAlternative(Boolean.class, false));
            this.put(Byte.TYPE, new PrimitiveAlternative(Byte.class, 0));
            this.put(Character.TYPE, new PrimitiveAlternative(Character.class, 0));
            this.put(Double.TYPE, new PrimitiveAlternative(Double.class, 0.0));
            this.put(Float.TYPE, new PrimitiveAlternative(Float.class, Float.valueOf(0.0f)));
            this.put(Integer.TYPE, new PrimitiveAlternative(Integer.class, 0));
            this.put(Long.TYPE, new PrimitiveAlternative(Long.class, 0));
            this.put(Short.TYPE, new PrimitiveAlternative(Short.class, 0));
        }
    };
    private final Injector injector;
    private final List<Class<? extends Filter>> globalFilterClassTypes;
    private final ErrorHandler errorHandler;
    private final Conversion conversion;
    private final Router router;
    private final Config configuration;
    private TemplateRenderer templateRenderer;

    public HttpRequestHandler(Injector injector, ErrorHandler errorHandler, List<Class<? extends Filter>> globalFilterClassTypes) {
        this.injector = injector;
        this.errorHandler = errorHandler;
        this.globalFilterClassTypes = globalFilterClassTypes;
        this.conversion = (Conversion)this.injector.getInstance(Conversion.class);
        this.router = (Router)this.injector.getInstance(Router.class);
        this.configuration = (Config)this.injector.getInstance(Config.class);
        try {
            this.templateRenderer = (TemplateRenderer)this.injector.getInstance(TemplateRenderer.class);
        }
        catch (Exception ignore) {
            this.templateRenderer = null;
        }
    }

    public Result onBadRequest(Context context, HttpException.BadRequest cause) {
        return this.errorHandler.onBadRequest(context, cause);
    }

    public Result onRouteRequest(Context context) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        for (Class<? extends Filter> filterClassType : this.globalFilterClassTypes) {
            filterList.add((Filter)this.injector.getInstance(filterClassType));
        }
        ResolvedRoute resolvedRoute = this.router.resolveRoute(context.getRequest().getHttpMethod(), context.getRequest().getRequestURI());
        if (resolvedRoute == null) {
            Filter callNotFoundFilter = (ctx, filterChain) -> {
                Result result = this.errorHandler.onNotFound(ctx, null);
                result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                return result;
            };
            filterList.add(callNotFoundFilter);
        } else {
            for (Class clazz : resolvedRoute.filterClassTypes()) {
                filterList.add((Filter)this.injector.getInstance(clazz));
            }
            Filter callControllerFile = (ctx, filterChain) -> {
                Object controllerInstance = this.injector.getInstance(resolvedRoute.controllerClassType());
                try {
                    Result result;
                    if (resolvedRoute.method().getParameterCount() == 0) {
                        result = (Result)resolvedRoute.method().invoke(controllerInstance, new Object[0]);
                    } else {
                        Object[] methodArgumentValueArray = this.buildMethodArguments(ctx, resolvedRoute);
                        result = (Result)resolvedRoute.method().invoke(controllerInstance, methodArgumentValueArray);
                    }
                    result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                    return result;
                }
                catch (Throwable throwable) {
                    Throwable cause;
                    Throwable throwable2 = cause = throwable.getCause() == null ? throwable : throwable.getCause();
                    Result result = cause instanceof HttpException.NotFound ? this.errorHandler.onNotFound(ctx, (HttpException.NotFound)cause) : (cause instanceof HttpException.BadRequest ? this.errorHandler.onBadRequest(ctx, (HttpException.BadRequest)cause) : this.errorHandler.onServerError(ctx, throwable));
                    result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                    return result;
                }
            };
            filterList.add(callControllerFile);
        }
        try {
            DefaultFilterChain filterChain2 = new DefaultFilterChain(filterList);
            return filterChain2.applyNext(context);
        }
        catch (Throwable throwable) {
            Result result = this.errorHandler.onServerError(context, throwable);
            result.getResultProcessor().process(context, this.configuration, this.templateRenderer);
            return result;
        }
    }

    private Object[] buildMethodArguments(Context context, ResolvedRoute resolvedRoute) {
        int idx = 0;
        Object[] methodArgumentValueArray = new Object[resolvedRoute.method().getParameterCount()];
        for (Parameter parameter : resolvedRoute.method().getParameters()) {
            if (parameter.getType().isAssignableFrom(Context.class)) {
                methodArgumentValueArray[idx] = context;
                ++idx;
                continue;
            }
            RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
            RequestPath requestPath = parameter.getAnnotation(RequestPath.class);
            RequestVariable requestVariable = parameter.getAnnotation(RequestVariable.class);
            if (requestBody != null) {
                if (context.getRequest().getBodyContent().contentType() != null) {
                    methodArgumentValueArray[idx] = switch (context.getRequest().getBodyContent().contentType()) {
                        case "application/json" -> context.getRequest().getBodyContent().asJson(parameter.getType());
                        case "application/x-www-form-urlencoded", "multipart/form-data" -> context.getRequest().getBodyContent().asFormData(parameter.getType());
                        case "text/yaml" -> context.getRequest().getBodyContent().asYaml(parameter.getType());
                        default -> throw new HttpException.BadRequest("Unhandled body content");
                    };
                } else {
                    methodArgumentValueArray[idx] = null;
                }
            } else {
                methodArgumentValueArray[idx] = requestPath != null ? this.convertValueToParameterType(resolvedRoute.extractedParameterValues().getOrDefault(requestPath.value(), null), parameter.getType()) : (requestVariable != null ? this.convertValueToParameterType(context.getRequest().getQueryStringParameter(requestVariable.value()), parameter.getType()) : this.injector.getInstance(parameter.getType()));
            }
            ++idx;
        }
        return methodArgumentValueArray;
    }

    private Object convertValueToParameterType(String value, Class<?> parameterTypeClass) {
        Object converterValue;
        Class<?> clazzToUse = parameterTypeClass;
        Object defaultValue = null;
        if (parameterTypeClass == String.class) {
            return value;
        }
        PrimitiveAlternative primitiveAlternative = PRIMITIVE_ALTERNATIVE_MAP.get(parameterTypeClass);
        if (primitiveAlternative != null) {
            clazzToUse = primitiveAlternative.replacementClass;
            defaultValue = primitiveAlternative.defaultValue;
        }
        return (converterValue = this.conversion.convert((Object)value, clazzToUse)) != null ? converterValue : defaultValue;
    }

    private record PrimitiveAlternative(Class<?> replacementClass, Object defaultValue) {
    }
}

