/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.core.bindable.BindClass;
import dev.voidframework.core.conversion.ConverterManager;
import dev.voidframework.core.conversion.TypeConverter;
import dev.voidframework.core.helper.ClassResolver;
import dev.voidframework.core.lifecycle.LifeCycleStart;
import dev.voidframework.core.lifecycle.LifeCycleStop;
import dev.voidframework.web.exception.ErrorHandlerException;
import dev.voidframework.web.exception.FilterException;
import dev.voidframework.web.exception.RoutingException;
import dev.voidframework.web.filter.Filter;
import dev.voidframework.web.http.ErrorHandler;
import dev.voidframework.web.http.HttpRequestHandler;
import dev.voidframework.web.http.converter.StringToBooleanConverter;
import dev.voidframework.web.http.converter.StringToByteConverter;
import dev.voidframework.web.http.converter.StringToCharacterConverter;
import dev.voidframework.web.http.converter.StringToDoubleConverter;
import dev.voidframework.web.http.converter.StringToFloatConverter;
import dev.voidframework.web.http.converter.StringToIntegerConverter;
import dev.voidframework.web.http.converter.StringToLongConverter;
import dev.voidframework.web.http.converter.StringToShortConverter;
import dev.voidframework.web.http.converter.StringToUUIDConverter;
import dev.voidframework.web.routing.AppRoutesDefinition;
import dev.voidframework.web.routing.Router;
import dev.voidframework.web.routing.RouterPostInitialization;
import dev.voidframework.web.server.SessionSigner;
import dev.voidframework.web.server.UndertowHttpHandler;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BindClass
@Singleton
public class WebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServer.class);
    private final Config configuration;
    private final Injector injector;
    private boolean isRunning;
    private Undertow undertowServer;
    private HttpRequestHandler httpRequestHandler;

    @Inject
    public WebServer(Config configuration, Injector injector) {
        this.configuration = configuration;
        this.injector = injector;
        this.undertowServer = null;
        this.httpRequestHandler = null;
    }

    @LifeCycleStart(priority=800)
    public void startWebServer() {
        ErrorHandler errorHandler;
        if (this.isRunning) {
            LOGGER.info("Web Daemon is already started!");
            return;
        }
        String errorHandlerClassName = this.configuration.getString("voidframework.web.errorHandler");
        Class errorHandlerClass = ClassResolver.forName((String)errorHandlerClassName);
        if (errorHandlerClass == null) {
            throw new ErrorHandlerException.ClassNotFound(errorHandlerClassName);
        }
        if (!ErrorHandler.class.isAssignableFrom(errorHandlerClass)) {
            throw new ErrorHandlerException.InvalidClass(errorHandlerClassName);
        }
        try {
            errorHandler = (ErrorHandler)this.injector.getInstance(errorHandlerClass);
            if (errorHandler == null) {
                throw new ErrorHandlerException.CantInstantiate(errorHandlerClassName);
            }
        }
        catch (Exception exception) {
            throw new ErrorHandlerException.CantInstantiate(errorHandlerClassName, exception);
        }
        ArrayList<Class<? extends Filter>> globalFilterList = new ArrayList<Class<? extends Filter>>();
        if (this.configuration.hasPath("voidframework.web.globalFilters")) {
            for (String filterName : this.configuration.getStringList("voidframework.web.globalFilters")) {
                Class filterClass = ClassResolver.forName((String)filterName);
                if (filterClass == null) {
                    throw new FilterException.LoadFailure(filterName);
                }
                globalFilterList.add(filterClass);
            }
        }
        this.httpRequestHandler = new HttpRequestHandler(this.injector, errorHandler, globalFilterList);
        ConverterManager converterManager = (ConverterManager)this.injector.getInstance(ConverterManager.class);
        converterManager.registerConverter(String.class, Boolean.class, (TypeConverter)new StringToBooleanConverter());
        converterManager.registerConverter(String.class, Byte.class, (TypeConverter)new StringToByteConverter());
        converterManager.registerConverter(String.class, Character.class, (TypeConverter)new StringToCharacterConverter());
        converterManager.registerConverter(String.class, Double.class, (TypeConverter)new StringToDoubleConverter());
        converterManager.registerConverter(String.class, Float.class, (TypeConverter)new StringToFloatConverter());
        converterManager.registerConverter(String.class, Integer.class, (TypeConverter)new StringToIntegerConverter());
        converterManager.registerConverter(String.class, Long.class, (TypeConverter)new StringToShortConverter());
        converterManager.registerConverter(String.class, Short.class, (TypeConverter)new StringToLongConverter());
        converterManager.registerConverter(String.class, UUID.class, (TypeConverter)new StringToUUIDConverter());
        Router router = (Router)this.injector.getInstance(Router.class);
        if (this.configuration.hasPath("voidframework.web.routes")) {
            this.configuration.getStringList("voidframework.web.routes").stream().filter(StringUtils::isNotEmpty).forEach(appRoutesDefinitionClassName -> {
                Class abstractRoutesDefinitionClass = ClassResolver.forName((String)appRoutesDefinitionClassName);
                if (abstractRoutesDefinitionClass == null) {
                    throw new RoutingException.AppRouteDefinitionLoadFailure((String)appRoutesDefinitionClassName);
                }
                AppRoutesDefinition appRoutesDefinition = (AppRoutesDefinition)this.injector.getInstance(abstractRoutesDefinitionClass);
                appRoutesDefinition.defineAppRoutes(router);
            });
        }
        if (router instanceof RouterPostInitialization) {
            ((RouterPostInitialization)((Object)router)).onPostInitialization();
        }
        UndertowHttpHandler httpHandler = new UndertowHttpHandler(this.configuration, this.httpRequestHandler, new SessionSigner(this.configuration));
        Undertow.Builder undertowBuilder = Undertow.builder().setServerOption(UndertowOptions.SHUTDOWN_TIMEOUT, (Object)this.configuration.getInt("voidframework.web.gracefulStopTimeout")).setServerOption(UndertowOptions.MULTIPART_MAX_ENTITY_SIZE, (Object)this.configuration.getMemorySize("voidframework.web.server.maxBodySize").toBytes()).setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)this.configuration.getMemorySize("voidframework.web.server.maxBodySize").toBytes()).addHttpListener(this.configuration.getInt("voidframework.web.server.listenPort"), this.configuration.getString("voidframework.web.server.listenHost")).setHandler(httpServerExchange -> httpServerExchange.dispatch(httpHandler));
        if (this.configuration.hasPath("voidframework.web.server.ioThreads") && this.configuration.getInt("voidframework.web.server.ioThreads") > 0) {
            undertowBuilder.setIoThreads(this.configuration.getInt("voidframework.web.server.ioThreads"));
        }
        if (this.configuration.hasPath("voidframework.web.server.workerThreads") && this.configuration.getInt("voidframework.web.server.workerThreads") > 0) {
            undertowBuilder.setWorkerThreads(this.configuration.getInt("voidframework.web.server.workerThreads"));
        }
        this.undertowServer = undertowBuilder.build();
        this.undertowServer.start();
        for (Undertow.ListenerInfo listenerInfo : this.undertowServer.getListenerInfo()) {
            LOGGER.info("Server now listening on {}:/{}", (Object)listenerInfo.getProtcol(), (Object)listenerInfo.getAddress());
        }
        this.isRunning = true;
    }

    @LifeCycleStop(gracefulStopTimeoutConfigKey="voidframework.web.gracefulStopTimeout")
    public void stopWebServer() {
        if (this.undertowServer != null) {
            this.undertowServer.stop();
            this.undertowServer = null;
            this.httpRequestHandler = null;
            this.isRunning = false;
        } else {
            LOGGER.info("Web Daemon is already stopped!");
        }
    }
}

