/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http.errorpage;

import dev.voidframework.web.routing.HttpMethod;
import dev.voidframework.web.routing.Route;
import java.util.List;

public final class DevMode404NotFound {
    private static final String TITLE = "404 Not Found";
    private static final String CSS_STYLE = "body {\n    margin: 0;\n    padding: 0;\n    background-color: #ececec;\n}\n\nheader {\n    padding: 5px 5px 5px 20px;\n    display: block;\n    background-color: #e7881c;\n    color: #ffffff;\n    font-weight: bold;\n}\n\n.subheader {\n    border: solid 3px #e7961c;\n    padding: 20px 20px 20px 20px;\n    display: block;\n    background-color: #edeadd;\n    color: #5d3604;\n    font-size: 1.2rem;\n    max-height: 250px;\n}\n\n.description {\n    padding: 20px 20px 5px 20px;\n    display: block;\n    font-size: 1rem;\n}\n\n.description table {\n    font-size: 1.0rem;\n    width: 100%%;\n}\n\n.description table tr td:first-child {\n    width: 80px;\n}\n\n.description table tr:nth-child(2n+1) {\n    background: #CCC\n}\n\n.error {\n    color: #c50101;\n}\n";
    private static final String CONTENT = "<html lang=\"en\">\n<head>\n    <title>404 Not Found    </title>\n    <style>\nbody {\n    margin: 0;\n    padding: 0;\n    background-color: #ececec;\n}\n\nheader {\n    padding: 5px 5px 5px 20px;\n    display: block;\n    background-color: #e7881c;\n    color: #ffffff;\n    font-weight: bold;\n}\n\n.subheader {\n    border: solid 3px #e7961c;\n    padding: 20px 20px 20px 20px;\n    display: block;\n    background-color: #edeadd;\n    color: #5d3604;\n    font-size: 1.2rem;\n    max-height: 250px;\n}\n\n.description {\n    padding: 20px 20px 5px 20px;\n    display: block;\n    font-size: 1rem;\n}\n\n.description table {\n    font-size: 1.0rem;\n    width: 100%%;\n}\n\n.description table tr td:first-child {\n    width: 80px;\n}\n\n.description table tr:nth-child(2n+1) {\n    background: #CCC\n}\n\n.error {\n    color: #c50101;\n}\n    </style>\n</head>\n<header>\n    <h1>No route has been found</h1>\n</header>\n<div class=\"subheader\">\n    <code>For request %s %s</code>\n</div>\n<div class=\"description\">\n    <h2>Available routes</h2>\n    <table>\n        %s\n    </table>\n    <br/>\n</div>\n</html>\n";
    private static final String FILE_PATTERN_ENTRY = "<tr>\n    <td><code>%s</code></td>\n    <td><pre>%s</pre></td>\n</tr>\n";

    public static String render(HttpMethod requestMethod, String requestUri, List<Route> routeList) {
        StringBuilder availableRoutesBuilder = new StringBuilder();
        for (Route route : routeList) {
            availableRoutesBuilder.append(FILE_PATTERN_ENTRY.formatted(new Object[]{route.httpMethod(), route.routePattern().toString()}));
        }
        return CONTENT.formatted(new Object[]{requestMethod, requestUri, availableRoutesBuilder.toString()});
    }
}

