/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.module;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import dev.voidframework.web.bindable.WebController;
import dev.voidframework.web.http.param.RequestRoute;
import dev.voidframework.web.routing.Router;
import java.lang.reflect.Method;

public class ControllerAnnotationListener
implements TypeListener {
    private final Router router;

    public ControllerAnnotationListener(Router router) {
        this.router = router;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class classType = type.getRawType();
        WebController webController = classType.getAnnotation(WebController.class);
        if (webController != null) {
            for (Method method : classType.getMethods()) {
                if (!method.isAnnotationPresent(RequestRoute.class)) continue;
                RequestRoute requestRoute = method.getAnnotation(RequestRoute.class);
                String completeRoute = this.appendPrefixToRoute(webController.prefixRoute(), requestRoute.route());
                this.router.addRoute(requestRoute.method(), completeRoute, classType, method, requestRoute.name());
            }
        }
    }

    private String appendPrefixToRoute(String prefix, String route) {
        String cleanedPrefix = this.cleanRoutePath(prefix);
        String cleanedRoute = this.cleanRoutePath(route);
        if (cleanedPrefix.endsWith("/") && cleanedRoute.charAt(0) == '/') {
            return cleanedPrefix + cleanedRoute.substring(1);
        }
        return this.cleanRoutePath(cleanedPrefix + cleanedRoute);
    }

    private String cleanRoutePath(String routePath) {
        Object cleanedRoutePath = routePath.trim();
        if (((String)cleanedRoutePath).isEmpty() || ((String)cleanedRoutePath).equals("/")) {
            return "/";
        }
        if (((String)cleanedRoutePath).charAt(0) != '/') {
            cleanedRoutePath = "/" + (String)cleanedRoutePath;
        }
        if (((String)cleanedRoutePath).endsWith("/")) {
            cleanedRoutePath = ((String)cleanedRoutePath).substring(0, ((String)cleanedRoutePath).length() - 1);
        }
        return cleanedRoutePath;
    }
}

