/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import java.time.Duration;

public record Cookie(String name, String value, String domain, String path, boolean isHttpOnly, boolean isSecure, String sameSiteMode, Duration timeToLive) {
    private static final String DEFAULT_PATH = "/";
    private static final String DEFAULT_SAME_SITE_POLICY = "Lax";

    static Cookie expired(String name) {
        return new Cookie(name, null, null, DEFAULT_PATH, false, false, DEFAULT_SAME_SITE_POLICY, Duration.ZERO);
    }

    public static Cookie of(String name, String value) {
        return new Cookie(name, value, null, DEFAULT_PATH, false, false, DEFAULT_SAME_SITE_POLICY, null);
    }

    public static Cookie of(String name, String value, boolean isHttpOnly, boolean isSecure, Duration timeToLive) {
        return new Cookie(name, value, null, DEFAULT_PATH, isHttpOnly, isSecure, DEFAULT_SAME_SITE_POLICY, timeToLive);
    }

    public static Cookie of(String name, String value, boolean isHttpOnly, boolean isSecure, String sameSiteMode, Duration timeToLive) {
        return new Cookie(name, value, null, DEFAULT_PATH, isHttpOnly, isSecure, sameSiteMode, timeToLive);
    }

    public static Cookie of(String name, String value, Duration timeToLive) {
        return new Cookie(name, value, null, DEFAULT_PATH, false, false, DEFAULT_SAME_SITE_POLICY, timeToLive);
    }
}

