/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http.controller;

import com.google.inject.Inject;
import dev.voidframework.i18n.Internationalization;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.HttpMethod;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.annotation.NoCSRF;
import dev.voidframework.web.http.annotation.RequestPath;
import dev.voidframework.web.http.annotation.RequestRoute;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractJavaScriptInternationalizationController {
    private static final String JAVASCRIPT_MAP_SEPARATOR = "': '";
    private static final String ESCAPED_SIMPLE_QUOTE = "\\'";
    private static final String JAVASCRIPT_CONTENT = "let i18n = new function () {\n\n    const _privateMessageMap = {\n        %s\n    };\n\n    this.getMessage = function (key) {\n\n        let msg = _privateMessageMap[key];\n        if (msg === undefined) {\n            return '%%' + key + '%%';\n        }\n\n        return msg;\n    };\n\n    this.getMessage = function (key, ...arguments) {\n\n        let msg = _privateMessageMap[key];\n        if (msg === undefined) {\n            return '%%' + key + '%%';\n        }\n\n        for (let idx = 0; idx < arguments.length; idx += 1) {\n            msg = msg.replace('{' + idx + '}', arguments[idx]);\n        }\n\n        return msg;\n    };\n};";
    protected final List<String> filterKeyPatternList;
    private final Internationalization internationalization;
    private final Map<Locale, String> jsFileContentCache;

    @Inject
    protected AbstractJavaScriptInternationalizationController(Internationalization internationalization) {
        this.internationalization = internationalization;
        this.jsFileContentCache = new ConcurrentHashMap<Locale, String>();
        this.filterKeyPatternList = new ArrayList<String>();
    }

    @NoCSRF
    @RequestRoute(method=HttpMethod.GET, route="/js/messages-(?<locale>[a-zA-Z_\\-]{2,6}).js", name="js_i18n")
    public Result jsInternationalizationScript(@RequestPath(value="locale") Locale locale) {
        if (locale == null) {
            throw new HttpException.NotFound();
        }
        String jsFileContent = this.jsFileContentCache.get(locale);
        if (jsFileContent == null) {
            jsFileContent = this.generateJavaScriptFile(locale);
            this.jsFileContentCache.put(locale, jsFileContent);
        }
        return Result.ok(jsFileContent, "application/javascript", StandardCharsets.UTF_8).withHeader("Cache-Control", "public, max-age=3600;");
    }

    private String generateJavaScriptFile(Locale locale) {
        Map messagePerKeyMap = this.internationalization.getAllMessages(locale);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : messagePerKeyMap.entrySet()) {
            if (!this.canUseKey((String)entry.getKey())) continue;
            stringBuilder.append("'").append(((String)entry.getKey()).replace("'", ESCAPED_SIMPLE_QUOTE)).append(JAVASCRIPT_MAP_SEPARATOR).append((String)entry.getValue()).append("'").append(",").append("\n");
        }
        return JAVASCRIPT_CONTENT.formatted(stringBuilder.toString());
    }

    private boolean canUseKey(String key) {
        if (this.filterKeyPatternList.isEmpty()) {
            return true;
        }
        for (String pattern : this.filterKeyPatternList) {
            if (!key.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

