/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.core.bindable.Bindable;
import dev.voidframework.core.conversion.ConverterManager;
import dev.voidframework.core.conversion.TypeConverter;
import dev.voidframework.core.lang.CUID;
import dev.voidframework.core.lifecycle.LifeCycleStart;
import dev.voidframework.core.lifecycle.LifeCycleStop;
import dev.voidframework.core.utils.ClassResolverUtils;
import dev.voidframework.web.exception.ErrorHandlerException;
import dev.voidframework.web.exception.ExtraWebServerConfigurationException;
import dev.voidframework.web.exception.FilterException;
import dev.voidframework.web.exception.HttpsWebServerConfigurationException;
import dev.voidframework.web.exception.RoutingException;
import dev.voidframework.web.http.HttpMethod;
import dev.voidframework.web.http.converter.StringToBooleanConverter;
import dev.voidframework.web.http.converter.StringToByteConverter;
import dev.voidframework.web.http.converter.StringToCUIDConverter;
import dev.voidframework.web.http.converter.StringToCharacterConverter;
import dev.voidframework.web.http.converter.StringToDoubleConverter;
import dev.voidframework.web.http.converter.StringToFloatConverter;
import dev.voidframework.web.http.converter.StringToIntegerConverter;
import dev.voidframework.web.http.converter.StringToLocaleConverter;
import dev.voidframework.web.http.converter.StringToLongConverter;
import dev.voidframework.web.http.converter.StringToShortConverter;
import dev.voidframework.web.http.converter.StringToUUIDConverter;
import dev.voidframework.web.http.errorhandler.ErrorHandler;
import dev.voidframework.web.http.filter.Filter;
import dev.voidframework.web.http.routing.AppRoutesDefinition;
import dev.voidframework.web.http.routing.Router;
import dev.voidframework.web.http.routing.RouterPostInitialization;
import dev.voidframework.web.server.ExtraWebServerConfiguration;
import dev.voidframework.web.server.http.HttpRequestHandler;
import dev.voidframework.web.server.http.HttpWebSocketRequestHandler;
import dev.voidframework.web.server.http.SessionSigner;
import dev.voidframework.web.server.http.UndertowHttpHandler;
import dev.voidframework.web.server.http.UndertowWebSocketCallback;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Options;
import org.xnio.Sequence;

@Bindable
@Singleton
public class WebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServer.class);
    private static final String CONFIGURATION_EXTRA_WEBSERVER_CONFIGURATION_IMPLEMENTATION = "voidframework.web.server.extraWebServerConfiguration";
    private static final String CONFIGURATION_KEY_ERROR_HANDLER_IMPLEMENTATION = "voidframework.web.errorHandler";
    private static final String CONFIGURATION_KEY_GLOBAL_FILTERS = "voidframework.web.globalFilters";
    private static final String CONFIGURATION_KEY_GRACEFUL_STOP_TIMEOUT = "voidframework.web.gracefulStopTimeout";
    private static final String CONFIGURATION_KEY_HTTPS_LISTEN_HOST = "voidframework.web.server.https.listenHost";
    private static final String CONFIGURATION_KEY_HTTPS_LISTEN_PORT = "voidframework.web.server.https.listenPort";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_PASSWORD = "voidframework.web.server.https.ssl.keyStorePassword";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_PATH = "voidframework.web.server.https.ssl.keyStorePath";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_TYPE = "voidframework.web.server.https.ssl.keyStoreType";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_KEY_ALIAS = "voidframework.web.server.https.ssl.keyAlias";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_KEY_PASSWORD = "voidframework.web.server.https.ssl.keyPassword";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_PROTOCOLS = "voidframework.web.server.https.ssl.protocols";
    private static final String CONFIGURATION_KEY_HTTPS_SSL_CIPHERS = "voidframework.web.server.https.ssl.ciphers";
    private static final String CONFIGURATION_KEY_HTTP_LISTEN_HOST = "voidframework.web.server.http.listenHost";
    private static final String CONFIGURATION_KEY_HTTP_LISTEN_PORT = "voidframework.web.server.http.listenPort";
    private static final String CONFIGURATION_KEY_IDLE_TIMEOUT = "voidframework.web.server.idleTimeout";
    private static final String CONFIGURATION_KEY_MAX_REQUEST_BODY_SIZE = "voidframework.web.server.maxBodySize";
    private static final String CONFIGURATION_KEY_NUMBER_IO_THREADS = "voidframework.web.server.ioThreads";
    private static final String CONFIGURATION_KEY_NUMBER_WORKER_THREADS = "voidframework.web.server.workerThreads";
    private static final String CONFIGURATION_KEY_ROUTES = "voidframework.web.routes";
    private final Config configuration;
    private final Injector injector;
    private boolean isRunning;
    private Undertow undertowServer;
    private HttpRequestHandler httpRequestHandler;
    private GracefulShutdownHandler httpGracefulShutdownHandler;

    @Inject
    public WebServer(Config configuration, Injector injector) {
        this.configuration = configuration;
        this.injector = injector;
        this.undertowServer = null;
        this.httpRequestHandler = null;
    }

    @LifeCycleStart(priority=700)
    public void startWebServer() {
        if (this.isRunning) {
            LOGGER.info("Web Daemon is already started!");
            return;
        }
        ErrorHandler errorHandler = this.instantiateErrorHandler();
        List<Class<? extends Filter>> globalFilterList = this.retrieveAllGlobalFilters();
        this.httpRequestHandler = new HttpRequestHandler(this.injector, errorHandler, globalFilterList);
        this.registerBuiltInConverters();
        Router router = this.loadProgrammaticallyDefinedRoutes();
        if (router instanceof RouterPostInitialization) {
            RouterPostInitialization routerAsRouterPostInit = (RouterPostInitialization)((Object)router);
            routerAsRouterPostInit.onPostInitialization();
        }
        this.undertowServer = this.createUndertowWebServer(router);
        this.undertowServer.start();
        if (LOGGER.isInfoEnabled()) {
            for (Undertow.ListenerInfo listenerInfo : this.undertowServer.getListenerInfo()) {
                LOGGER.info("Server now listening on {}:/{}{}", new Object[]{listenerInfo.getProtcol(), listenerInfo.getAddress(), this.configuration.getString("voidframework.web.contextPath")});
            }
        }
        this.isRunning = true;
    }

    @LifeCycleStop(priority=700, gracefulStopTimeoutConfigKey="voidframework.web.gracefulStopTimeout")
    public void stopWebServer() throws InterruptedException {
        if (this.undertowServer != null) {
            if (this.httpGracefulShutdownHandler != null) {
                this.httpGracefulShutdownHandler.shutdown();
                this.httpGracefulShutdownHandler.awaitShutdown();
            } else {
                this.undertowServer.stop();
            }
            this.undertowServer = null;
            this.httpRequestHandler = null;
            this.httpGracefulShutdownHandler = null;
            this.isRunning = false;
        } else {
            LOGGER.info("Web Daemon is already stopped!");
        }
    }

    private Router loadProgrammaticallyDefinedRoutes() {
        Router router = (Router)this.injector.getInstance(Router.class);
        this.configuration.getStringList(CONFIGURATION_KEY_ROUTES).stream().filter(StringUtils::isNotEmpty).forEach(appRoutesDefinitionClassName -> {
            Class abstractRoutesDefinitionClass = ClassResolverUtils.forName((String)appRoutesDefinitionClassName);
            if (abstractRoutesDefinitionClass == null) {
                throw new RoutingException.AppRouteDefinitionLoadFailure((String)appRoutesDefinitionClassName);
            }
            AppRoutesDefinition appRoutesDefinition = (AppRoutesDefinition)this.injector.getInstance(abstractRoutesDefinitionClass);
            appRoutesDefinition.defineAppRoutes(router);
        });
        return router;
    }

    private List<Class<? extends Filter>> retrieveAllGlobalFilters() {
        ArrayList<Class<? extends Filter>> globalFilterList = new ArrayList<Class<? extends Filter>>();
        for (String filterName : this.configuration.getStringList(CONFIGURATION_KEY_GLOBAL_FILTERS)) {
            Class filterClass = ClassResolverUtils.forName((String)filterName);
            if (filterClass == null) {
                throw new FilterException.LoadFailure(filterName);
            }
            globalFilterList.add(filterClass);
        }
        return globalFilterList;
    }

    private ErrorHandler instantiateErrorHandler() {
        String errorHandlerClassName = this.configuration.getString(CONFIGURATION_KEY_ERROR_HANDLER_IMPLEMENTATION);
        final Class errorHandlerClass = ClassResolverUtils.forName((String)errorHandlerClassName);
        if (errorHandlerClass == null) {
            throw new ErrorHandlerException.ClassNotFound(errorHandlerClassName);
        }
        if (!ErrorHandler.class.isAssignableFrom(errorHandlerClass)) {
            throw new ErrorHandlerException.InvalidClass(errorHandlerClassName);
        }
        try {
            Injector childInjector = this.injector.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(errorHandlerClass);
                }
            }});
            ErrorHandler errorHandler = (ErrorHandler)childInjector.getInstance(errorHandlerClass);
            if (errorHandler == null) {
                throw new ErrorHandlerException.CantInstantiate(errorHandlerClassName);
            }
            return errorHandler;
        }
        catch (Exception exception) {
            throw new ErrorHandlerException.CantInstantiate(errorHandlerClassName, exception);
        }
    }

    private void registerBuiltInConverters() {
        ConverterManager converterManager = (ConverterManager)this.injector.getInstance(ConverterManager.class);
        converterManager.registerConverter(String.class, Boolean.class, (TypeConverter)new StringToBooleanConverter());
        converterManager.registerConverter(String.class, Byte.class, (TypeConverter)new StringToByteConverter());
        converterManager.registerConverter(String.class, CUID.class, (TypeConverter)new StringToCUIDConverter());
        converterManager.registerConverter(String.class, Character.class, (TypeConverter)new StringToCharacterConverter());
        converterManager.registerConverter(String.class, Double.class, (TypeConverter)new StringToDoubleConverter());
        converterManager.registerConverter(String.class, Float.class, (TypeConverter)new StringToFloatConverter());
        converterManager.registerConverter(String.class, Integer.class, (TypeConverter)new StringToIntegerConverter());
        converterManager.registerConverter(String.class, Locale.class, (TypeConverter)new StringToLocaleConverter());
        converterManager.registerConverter(String.class, Long.class, (TypeConverter)new StringToShortConverter());
        converterManager.registerConverter(String.class, Short.class, (TypeConverter)new StringToLongConverter());
        converterManager.registerConverter(String.class, UUID.class, (TypeConverter)new StringToUUIDConverter());
    }

    private Undertow createUndertowWebServer(Router router) {
        Undertow.Builder undertowBuilder = Undertow.builder().setServerOption(UndertowOptions.SHUTDOWN_TIMEOUT, (Object)((int)this.configuration.getDuration(CONFIGURATION_KEY_GRACEFUL_STOP_TIMEOUT, TimeUnit.MILLISECONDS))).setServerOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)((int)this.configuration.getDuration(CONFIGURATION_KEY_IDLE_TIMEOUT, TimeUnit.MILLISECONDS))).setServerOption(UndertowOptions.MULTIPART_MAX_ENTITY_SIZE, (Object)this.configuration.getMemorySize(CONFIGURATION_KEY_MAX_REQUEST_BODY_SIZE).toBytes()).setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)this.configuration.getMemorySize(CONFIGURATION_KEY_MAX_REQUEST_BODY_SIZE).toBytes()).addHttpListener(this.configuration.getInt(CONFIGURATION_KEY_HTTP_LISTEN_PORT), this.configuration.getString(CONFIGURATION_KEY_HTTP_LISTEN_HOST));
        if (this.configuration.hasPath(CONFIGURATION_KEY_HTTPS_LISTEN_HOST) && this.configuration.hasPath(CONFIGURATION_KEY_HTTPS_LISTEN_PORT) && this.configuration.hasPath(CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_PATH)) {
            undertowBuilder.addHttpsListener(this.configuration.getInt(CONFIGURATION_KEY_HTTPS_LISTEN_PORT), this.configuration.getString(CONFIGURATION_KEY_HTTPS_LISTEN_HOST), this.createSSLContext());
            undertowBuilder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of((Collection)this.configuration.getStringList(CONFIGURATION_KEY_HTTPS_SSL_PROTOCOLS)));
            List enableCipherList = this.configuration.getStringList(CONFIGURATION_KEY_HTTPS_SSL_CIPHERS);
            if (!enableCipherList.isEmpty()) {
                undertowBuilder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of((Collection)enableCipherList));
            }
        }
        if (this.configuration.hasPath(CONFIGURATION_KEY_NUMBER_IO_THREADS) && this.configuration.getInt(CONFIGURATION_KEY_NUMBER_IO_THREADS) > 0) {
            undertowBuilder.setIoThreads(this.configuration.getInt(CONFIGURATION_KEY_NUMBER_IO_THREADS));
        }
        if (this.configuration.hasPath(CONFIGURATION_KEY_NUMBER_WORKER_THREADS) && this.configuration.getInt(CONFIGURATION_KEY_NUMBER_WORKER_THREADS) > 0) {
            undertowBuilder.setWorkerThreads(this.configuration.getInt(CONFIGURATION_KEY_NUMBER_WORKER_THREADS));
        }
        UndertowHttpHandler httpHandler = new UndertowHttpHandler(this.configuration, this.httpRequestHandler, new SessionSigner(this.configuration));
        this.httpGracefulShutdownHandler = new GracefulShutdownHandler((HttpHandler)httpHandler);
        if (router.getRoutesAsMap().get((Object)HttpMethod.WEBSOCKET) != null) {
            HttpWebSocketRequestHandler wsIncomingConnHandler = new HttpWebSocketRequestHandler(this.injector);
            UndertowWebSocketCallback wsCallback = new UndertowWebSocketCallback(wsIncomingConnHandler);
            WebSocketProtocolHandshakeHandler wsHandler = new WebSocketProtocolHandshakeHandler((WebSocketConnectionCallback)wsCallback, (HttpHandler)this.httpGracefulShutdownHandler);
            undertowBuilder.setHandler((HttpHandler)wsHandler);
        } else {
            undertowBuilder.setHandler((HttpHandler)this.httpGracefulShutdownHandler);
        }
        if (this.configuration.hasPath(CONFIGURATION_EXTRA_WEBSERVER_CONFIGURATION_IMPLEMENTATION)) {
            this.applyExtraWebServerConfiguration(undertowBuilder, this.configuration.getString(CONFIGURATION_EXTRA_WEBSERVER_CONFIGURATION_IMPLEMENTATION));
        }
        return undertowBuilder.build();
    }

    private void applyExtraWebServerConfiguration(Undertow.Builder undertowBuilder, String extraWebServerConfigurationClassName) {
        ExtraWebServerConfiguration extraWebServerConfiguration;
        Class extraWebServerConfigurationClass = ClassResolverUtils.forName((String)extraWebServerConfigurationClassName);
        if (extraWebServerConfigurationClass == null) {
            throw new ExtraWebServerConfigurationException.ClassNotFound(extraWebServerConfigurationClassName);
        }
        if (!ExtraWebServerConfiguration.class.isAssignableFrom(extraWebServerConfigurationClass)) {
            throw new ExtraWebServerConfigurationException.InvalidClass(extraWebServerConfigurationClassName);
        }
        try {
            extraWebServerConfiguration = (ExtraWebServerConfiguration)this.injector.getInstance(extraWebServerConfigurationClass);
            if (extraWebServerConfiguration == null) {
                throw new ExtraWebServerConfigurationException.CantInstantiate(extraWebServerConfigurationClassName);
            }
        }
        catch (Exception exception) {
            throw new ExtraWebServerConfigurationException.CantInstantiate(extraWebServerConfigurationClassName, exception);
        }
        extraWebServerConfiguration.doExtraConfiguration(undertowBuilder);
    }

    private SSLContext createSSLContext() {
        KeyManagerFactory keyManagerFactory;
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(this.configuration.getString(CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_TYPE));
            keyStore.load(this.tryOpenKeyStore(), this.configuration.getString(CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_PASSWORD).toCharArray());
            if (this.configuration.hasPath(CONFIGURATION_KEY_HTTPS_SSL_KEY_ALIAS)) {
                Iterator<String> it = keyStore.aliases().asIterator();
                while (it.hasNext()) {
                    String keyAlias = it.next();
                    if (Objects.equals(keyAlias, this.configuration.getString(CONFIGURATION_KEY_HTTPS_SSL_KEY_ALIAS))) continue;
                    keyStore.deleteEntry(keyAlias);
                }
                if (keyStore.size() == 0) {
                    throw new HttpsWebServerConfigurationException.KeyNotFound(this.configuration.getString(CONFIGURATION_KEY_HTTPS_SSL_KEY_ALIAS));
                }
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new HttpsWebServerConfigurationException.CannotLoadKeyStore(exception);
        }
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.configuration.getString(CONFIGURATION_KEY_HTTPS_SSL_KEY_PASSWORD).toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
            throw new HttpsWebServerConfigurationException.KeyManagerInitFailure(exception);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            return sslContext;
        }
        catch (IndexOutOfBoundsException | KeyManagementException | NoSuchAlgorithmException exception) {
            throw new HttpsWebServerConfigurationException.SSLContextInitFailure(exception);
        }
    }

    private InputStream tryOpenKeyStore() throws IOException {
        String keyStorePath = this.configuration.getString(CONFIGURATION_KEY_HTTPS_SSL_KEYSTORE_PATH);
        URL keyStoreURL = this.getClass().getResource((String)(keyStorePath.startsWith("/") ? keyStorePath : "/" + keyStorePath));
        if (keyStoreURL != null) {
            return keyStoreURL.openStream();
        }
        try {
            keyStoreURL = new URL(keyStorePath);
            return keyStoreURL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            return new FileInputStream(keyStorePath);
        }
    }
}

