/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import com.fasterxml.jackson.databind.JsonNode;
import dev.voidframework.core.helper.Json;
import dev.voidframework.core.helper.Reflection;
import dev.voidframework.core.helper.Xml;
import dev.voidframework.core.helper.Yaml;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.FormItem;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;

public record HttpRequestBodyContent(String contentType, byte[] asRaw, Map<String, List<FormItem>> asFormData) {
    public <T> T asFormData(Class<T> outputClass) {
        HashMap<String, String> flatValueMap = new HashMap<String, String>();
        HashMap<String, InputStream> flatFileMap = new HashMap<String, InputStream>();
        for (Map.Entry<String, List<FormItem>> entry : this.asFormData.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            if (!entry.getValue().get(0).isFile()) {
                flatValueMap.put(entry.getKey(), entry.getValue().get(0).value());
                continue;
            }
            flatFileMap.put(entry.getKey(), entry.getValue().get(0).inputStream());
        }
        Object output = Json.fromMap(flatValueMap, outputClass);
        for (Map.Entry entry : flatFileMap.entrySet()) {
            Reflection.setFieldValue((Object)output, (String)((String)entry.getKey()), entry.getValue());
        }
        return (T)output;
    }

    public JsonNode asJson() {
        return Json.toJson((byte[])this.asRaw);
    }

    public <T> T as(Class<T> outputClass) {
        return switch (this.contentType()) {
            case "application/json" -> Json.fromJson((byte[])this.asRaw, outputClass);
            case "application/x-www-form-urlencoded", "multipart/form-data" -> this.asFormData(outputClass);
            case "application/xml" -> Xml.fromXml((byte[])this.asRaw, outputClass);
            case "text/yaml" -> Yaml.fromYaml((byte[])this.asRaw, outputClass);
            default -> throw new HttpException.BadRequest("Unhandled body content");
        };
    }

    public Document asXml() {
        return Xml.toXml((byte[])this.asRaw);
    }

    public JsonNode asYaml() {
        return Yaml.toYaml((byte[])this.asRaw);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequestBodyContent that = (HttpRequestBodyContent)o;
        return Objects.equals(this.contentType, that.contentType) && Arrays.equals(this.asRaw, that.asRaw) && Objects.equals(this.asFormData, that.asFormData);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.contentType, this.asFormData);
        result = 31 * result + Arrays.hashCode(this.asRaw);
        return result;
    }

    @Override
    public String toString() {
        return "HttpRequestBodyContent{contentType='" + this.contentType + "}";
    }
}

