/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import com.google.inject.Injector;
import com.typesafe.config.Config;
import dev.voidframework.core.conversion.Conversion;
import dev.voidframework.template.TemplateRenderer;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.annotation.NoCSRF;
import dev.voidframework.web.http.annotation.RequestBody;
import dev.voidframework.web.http.annotation.RequestPath;
import dev.voidframework.web.http.annotation.RequestVariable;
import dev.voidframework.web.http.errorhandler.ErrorHandler;
import dev.voidframework.web.http.filter.DefaultFilterChain;
import dev.voidframework.web.http.filter.Filter;
import dev.voidframework.web.http.filter.csrf.CSRFFilter;
import dev.voidframework.web.http.routing.ResolvedRoute;
import dev.voidframework.web.http.routing.Router;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class HttpRequestHandler {
    private static final Map<Class<?>, PrimitiveAlternative> PRIMITIVE_ALTERNATIVE_MAP = Map.ofEntries(Map.entry(Boolean.TYPE, new PrimitiveAlternative(Boolean.class, false)), Map.entry(Byte.TYPE, new PrimitiveAlternative(Byte.class, 0)), Map.entry(Character.TYPE, new PrimitiveAlternative(Character.class, 0)), Map.entry(Double.TYPE, new PrimitiveAlternative(Double.class, 0.0)), Map.entry(Float.TYPE, new PrimitiveAlternative(Float.class, Float.valueOf(0.0f))), Map.entry(Integer.TYPE, new PrimitiveAlternative(Integer.class, 0)), Map.entry(Long.TYPE, new PrimitiveAlternative(Long.class, 0)), Map.entry(Short.TYPE, new PrimitiveAlternative(Short.class, 0)));
    private final Injector injector;
    private final List<Class<? extends Filter>> globalFilterClassTypes;
    private final ErrorHandler errorHandler;
    private final Conversion conversion;
    private final Router router;
    private final Config configuration;
    private TemplateRenderer templateRenderer;

    public HttpRequestHandler(Injector injector, ErrorHandler errorHandler, List<Class<? extends Filter>> globalFilterClassTypes) {
        this.injector = injector;
        this.errorHandler = errorHandler;
        this.globalFilterClassTypes = globalFilterClassTypes;
        this.conversion = (Conversion)this.injector.getInstance(Conversion.class);
        this.router = (Router)this.injector.getInstance(Router.class);
        this.configuration = (Config)this.injector.getInstance(Config.class);
        try {
            this.templateRenderer = (TemplateRenderer)this.injector.getInstance(TemplateRenderer.class);
        }
        catch (Exception ignore) {
            this.templateRenderer = null;
        }
    }

    public Result onBadRequest(Context context, HttpException.BadRequest cause) {
        return this.errorHandler.onBadRequest(context, cause);
    }

    public Result onRouteRequest(Context context) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        for (Class<? extends Filter> filterClassType : this.globalFilterClassTypes) {
            filterList.add((Filter)this.injector.getInstance(filterClassType));
        }
        ResolvedRoute resolvedRoute = this.router.resolveRoute(context.getRequest().getHttpMethod(), context.getRequest().getRequestURI());
        if (resolvedRoute == null) {
            context.getAttributes().put(CSRFFilter.BYPASS_CSRF_VERIFICATION, (Object)Boolean.TRUE);
            Filter callNotFoundFilter = (ctx, filterChain) -> {
                Result result = this.errorHandler.onNotFound(ctx, null);
                result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                return result;
            };
            filterList.add(callNotFoundFilter);
        } else {
            if (resolvedRoute.controllerClassType().isAnnotationPresent(NoCSRF.class) || resolvedRoute.method().isAnnotationPresent(NoCSRF.class)) {
                context.getAttributes().put(CSRFFilter.BYPASS_CSRF_VERIFICATION, (Object)Boolean.TRUE);
            }
            for (Class clazz : resolvedRoute.filterClassTypes()) {
                filterList.add((Filter)this.injector.getInstance(clazz));
            }
            Filter callControllerFile = (ctx, filterChain) -> {
                Object controllerInstance = this.injector.getInstance(resolvedRoute.controllerClassType());
                try {
                    Result result;
                    if (resolvedRoute.method().getParameterCount() == 0) {
                        result = (Result)resolvedRoute.method().invoke(controllerInstance, new Object[0]);
                    } else {
                        Object[] methodArgumentValueArray = this.buildMethodArguments(ctx, resolvedRoute);
                        result = (Result)resolvedRoute.method().invoke(controllerInstance, methodArgumentValueArray);
                    }
                    result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                    return result;
                }
                catch (Throwable throwable) {
                    Throwable cause;
                    Throwable throwable2 = cause = throwable.getCause() == null ? throwable : throwable.getCause();
                    Result result = cause instanceof HttpException.NotFound ? this.errorHandler.onNotFound(ctx, (HttpException.NotFound)cause) : (cause instanceof HttpException.BadRequest ? this.errorHandler.onBadRequest(ctx, (HttpException.BadRequest)cause) : this.errorHandler.onServerError(ctx, throwable));
                    result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                    return result;
                }
            };
            filterList.add(callControllerFile);
        }
        try {
            DefaultFilterChain filterChain2 = new DefaultFilterChain(filterList);
            return filterChain2.applyNext(context);
        }
        catch (Throwable throwable) {
            Result result = this.errorHandler.onServerError(context, throwable);
            result.getResultProcessor().process(context, this.configuration, this.templateRenderer);
            return result;
        }
    }

    private Object[] buildMethodArguments(Context context, ResolvedRoute resolvedRoute) {
        int idx = 0;
        Object[] methodArgumentValueArray = new Object[resolvedRoute.method().getParameterCount()];
        for (Parameter parameter : resolvedRoute.method().getParameters()) {
            if (parameter.getType().isAssignableFrom(Context.class)) {
                methodArgumentValueArray[idx] = context;
                ++idx;
                continue;
            }
            RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
            RequestPath requestPath = parameter.getAnnotation(RequestPath.class);
            RequestVariable requestVariable = parameter.getAnnotation(RequestVariable.class);
            methodArgumentValueArray[idx] = requestBody != null ? (context.getRequest().getBodyContent().contentType() != null ? context.getRequest().getBodyContent().as(parameter.getType()) : null) : (requestPath != null ? this.convertValueToParameterType(resolvedRoute.extractedParameterValues().getOrDefault(requestPath.value(), null), parameter.getType()) : (requestVariable != null ? this.convertValueToParameterType(context.getRequest().getQueryStringParameter(requestVariable.value()), parameter.getType()) : this.injector.getInstance(parameter.getType())));
            ++idx;
        }
        return methodArgumentValueArray;
    }

    private Object convertValueToParameterType(String value, Class<?> parameterTypeClass) {
        Object converterValue;
        Class<?> clazzToUse = parameterTypeClass;
        Object defaultValue = null;
        if (parameterTypeClass == String.class) {
            return value;
        }
        PrimitiveAlternative primitiveAlternative = PRIMITIVE_ALTERNATIVE_MAP.get(parameterTypeClass);
        if (primitiveAlternative != null) {
            clazzToUse = primitiveAlternative.replacementClass;
            defaultValue = primitiveAlternative.defaultValue;
        }
        return (converterValue = this.conversion.convert((Object)value, clazzToUse)) != null ? converterValue : defaultValue;
    }

    private record PrimitiveAlternative(Class<?> replacementClass, Object defaultValue) {
    }
}

