/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import com.google.common.collect.ImmutableList;
import dev.voidframework.web.http.Cookie;
import dev.voidframework.web.http.HttpMethod;
import dev.voidframework.web.http.HttpRequest;
import dev.voidframework.web.http.HttpRequestBodyContent;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.io.InputStream;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UndertowRequest
implements HttpRequest {
    private final HttpServerExchange httpServerExchange;
    private final HttpRequestBodyContent httpRequestBodyContent;
    private Map<String, List<String>> headerMapCache;

    public UndertowRequest(HttpServerExchange httpServerExchange, HttpRequestBodyContent httpRequestBodyContent) {
        this.httpServerExchange = httpServerExchange;
        this.httpRequestBodyContent = httpRequestBodyContent;
    }

    @Override
    public String getCharset() {
        return this.httpServerExchange.getRequestCharset();
    }

    @Override
    public Cookie getCookie(String cookieName) {
        io.undertow.server.handlers.Cookie c = this.httpServerExchange.getRequestCookie(cookieName);
        return c != null ? Cookie.of(c.getName(), c.getValue()) : null;
    }

    @Override
    public boolean acceptContentType(String contentType) {
        HeaderValues acceptHeaderValues = this.httpServerExchange.getRequestHeaders().get("Accept");
        if (acceptHeaderValues == null || acceptHeaderValues.isEmpty()) {
            return false;
        }
        for (String value : acceptHeaderValues.get(0).split(",")) {
            if (!value.contains(contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getHeader(String headerName) {
        return this.httpServerExchange.getRequestHeaders().getFirst(headerName);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headerMapCache == null) {
            this.headerMapCache = new HashMap<String, List<String>>();
            for (HeaderValues headerValues : this.httpServerExchange.getRequestHeaders()) {
                this.headerMapCache.put(headerValues.getHeaderName().toString(), headerValues.subList(0, headerValues.size()));
            }
        }
        return this.headerMapCache;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.valueOf(this.httpServerExchange.getRequestMethod().toString());
    }

    @Override
    public InputStream getInputSteam() {
        return this.httpServerExchange.getInputStream();
    }

    @Override
    public String getQueryString() {
        return this.httpServerExchange.getQueryString();
    }

    @Override
    public String getQueryStringParameter(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        Deque parameetersValueDeque = (Deque)this.httpServerExchange.getQueryParameters().get(parameterName);
        return parameetersValueDeque == null ? null : (String)parameetersValueDeque.getFirst();
    }

    @Override
    public Map<String, List<String>> getQueryStringParameters() {
        HashMap<String, List<String>> parametersPerKeyMap = new HashMap<String, List<String>>();
        for (Map.Entry entrySet : this.httpServerExchange.getQueryParameters().entrySet()) {
            parametersPerKeyMap.put((String)entrySet.getKey(), (List<String>)ImmutableList.copyOf((Collection)((Collection)entrySet.getValue())));
        }
        return parametersPerKeyMap;
    }

    @Override
    public String getRemoteHostName() {
        return this.httpServerExchange.getHostName();
    }

    @Override
    public String getRequestURL() {
        return this.httpServerExchange.getRequestURL();
    }

    @Override
    public String getRequestURI() {
        return this.httpServerExchange.getRequestURI();
    }

    @Override
    public HttpRequestBodyContent getBodyContent() {
        return this.httpRequestBodyContent;
    }
}

