/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.config.Config;
import dev.voidframework.core.helper.IO;
import dev.voidframework.core.helper.Json;
import dev.voidframework.core.lang.Either;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.Cookie;
import dev.voidframework.web.http.FlashMessages;
import dev.voidframework.web.http.FormItem;
import dev.voidframework.web.http.HttpRequest;
import dev.voidframework.web.http.HttpRequestBodyContent;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.Session;
import dev.voidframework.web.server.http.HttpRequestHandler;
import dev.voidframework.web.server.http.SessionSigner;
import dev.voidframework.web.server.http.UndertowRequest;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UndertowHttpHandler
implements HttpHandler {
    private static final Duration COOKIE_LANG_DURATION = Duration.ofDays(365L);
    private final Config configuration;
    private final HttpRequestHandler httpRequestHandler;
    private final SessionSigner sessionSigner;
    private final FormEncodedDataDefinition formEncodedDataDefinition;
    private final MultiPartParserDefinition multiPartParserDefinition;

    public UndertowHttpHandler(Config configuration, HttpRequestHandler httpRequestHandler, SessionSigner sessionSigner) {
        this.configuration = configuration;
        this.httpRequestHandler = httpRequestHandler;
        this.sessionSigner = sessionSigner;
        this.formEncodedDataDefinition = new FormEncodedDataDefinition();
        this.formEncodedDataDefinition.setDefaultEncoding("UTF-8");
        this.multiPartParserDefinition = new MultiPartParserDefinition().setTempFileLocation(null).setDefaultEncoding("UTF-8");
        this.multiPartParserDefinition.setFileSizeThreshold(this.configuration.getMemorySize("voidframework.web.server.fileSizeThreshold").toBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange httpServerExchange) {
        Result result;
        httpServerExchange.startBlocking();
        Either<HttpRequest, HttpException.BadRequest> httpRequestOrException = this.createHttpRequestWithOptionalBodyContent(httpServerExchange);
        HttpRequest httpRequest = httpRequestOrException.hasLeft() ? (HttpRequest)httpRequestOrException.getLeft() : this.createHttpRequestWithoutBodyContent(httpServerExchange);
        Cookie sessionCookie = httpRequest.getCookie(this.configuration.getString("voidframework.web.session.cookieName"));
        Session session = sessionCookie != null ? this.sessionSigner.verify(sessionCookie.value()) : new Session();
        Cookie flashMessagesCookie = httpRequest.getCookie(this.configuration.getString("voidframework.web.flashMessages.cookieName"));
        FlashMessages flashMessages = flashMessagesCookie != null ? new FlashMessages((Map)Json.fromJson((JsonNode)Json.toJson((byte[])flashMessagesCookie.value().getBytes(StandardCharsets.UTF_8)), FlashMessages.class)) : new FlashMessages();
        List availableLanguageList = this.configuration.getStringList("voidframework.web.language.availableLanguages");
        Cookie i18nCookie = httpRequest.getCookie(this.configuration.getString("voidframework.web.language.cookieName"));
        Locale i18nLocale = i18nCookie != null && availableLanguageList.contains(i18nCookie.value()) ? Locale.forLanguageTag(i18nCookie.value()) : (availableLanguageList.isEmpty() ? null : Locale.forLanguageTag((String)availableLanguageList.get(0)));
        Context context = new Context(httpRequest, session, flashMessages, i18nLocale);
        Result result2 = result = httpRequestOrException.hasLeft() ? this.httpRequestHandler.onRouteRequest(context) : this.httpRequestHandler.onBadRequest(context, (HttpException.BadRequest)httpRequestOrException.getRight());
        if (httpServerExchange.isComplete()) {
            return;
        }
        httpServerExchange.setStatusCode(result.getHttpCode());
        httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, result.getContentType());
        for (Map.Entry<String, String> entrySet : result.getHeaders().entrySet()) {
            httpServerExchange.getResponseHeaders().put(new HttpString(entrySet.getKey()), entrySet.getValue());
        }
        if (context.getSession().isModified()) {
            sessionCookie = Cookie.of(this.configuration.getString("voidframework.web.session.cookieName"), this.sessionSigner.sign(context.getSession()), this.configuration.getBoolean("voidframework.web.session.cookieHttpOnly"), this.configuration.getBoolean("voidframework.web.session.cookieSecure"), !context.getSession().isEmpty() ? this.configuration.getDuration("voidframework.web.session.timeToLive") : Duration.ZERO);
            result.withCookie(sessionCookie);
        }
        if (context.getFlashMessages().isModified()) {
            flashMessagesCookie = Cookie.of(this.configuration.getString("voidframework.web.flashMessages.cookieName"), Json.toJson((Object)context.getFlashMessages()).toString(), this.configuration.getBoolean("voidframework.web.flashMessages.cookieHttpOnly"), this.configuration.getBoolean("voidframework.web.flashMessages.cookieSecure"), context.getFlashMessages().isEmpty() ? Duration.ZERO : null);
            result.withCookie(flashMessagesCookie);
        }
        if (context.getLocale() != null && context.getLocale() != i18nLocale) {
            i18nCookie = Cookie.of(this.configuration.getString("voidframework.web.language.cookieName"), context.getLocale().toLanguageTag(), this.configuration.getBoolean("voidframework.web.language.cookieHttpOnly"), this.configuration.getBoolean("voidframework.web.language.cookieSecure"), COOKIE_LANG_DURATION);
            result.withCookie(i18nCookie);
        }
        for (Cookie cookie : result.getCookies().values()) {
            CookieImpl cookieImpl = new CookieImpl(cookie.name(), cookie.value()).setDomain(cookie.domain()).setPath(cookie.path()).setHttpOnly(cookie.isHttpOnly()).setSecure(cookie.isSecure()).setDiscard(cookie.timeToLive() == Duration.ZERO);
            if (cookie.timeToLive() != null) {
                cookieImpl = cookieImpl.setMaxAge(Integer.valueOf((int)cookie.timeToLive().toSeconds()));
            }
            httpServerExchange.setResponseCookie(cookieImpl.setSameSite(true).setSameSiteMode(cookie.sameSiteMode()));
        }
        InputStream inputStream = result.getResultProcessor().getInputStream();
        if (inputStream != null) {
            OutputStream outputStream = httpServerExchange.getOutputStream();
            try {
                int readLength;
                httpServerExchange.setResponseContentLength((long)inputStream.available());
                byte[] buffer = new byte[8192];
                while ((readLength = inputStream.read(buffer, 0, buffer.length)) > 0) {
                    outputStream.write(buffer, 0, readLength);
                    outputStream.flush();
                }
            }
            catch (Exception exception) {
            }
            finally {
                IO.closeWithoutException((OutputStream)outputStream);
                IO.closeWithoutException((InputStream)inputStream);
            }
        }
    }

    private Either<HttpRequest, HttpException.BadRequest> createHttpRequestWithOptionalBodyContent(HttpServerExchange httpServerExchange) {
        HttpRequest httpRequest;
        String contentType = httpServerExchange.getRequestHeaders().getLast("Content-Type");
        if (contentType != null) {
            contentType = contentType.split(";")[0];
        }
        if (contentType != null) {
            try (FormDataParser formDataParser = FormParserFactory.builder((boolean)false).addParsers(new FormParserFactory.ParserDefinition[]{this.formEncodedDataDefinition, this.multiPartParserDefinition}).build().createParser(httpServerExchange);){
                if (formDataParser != null) {
                    HashMap<String, List<FormItem>> formItemPerKeyMap = new HashMap<String, List<FormItem>>();
                    FormData formData = formDataParser.parseBlocking();
                    for (String formDataKey : formData) {
                        List formItemList = formItemPerKeyMap.computeIfAbsent(formDataKey, k -> new ArrayList());
                        for (FormData.FormValue formValue : formData.get(formDataKey)) {
                            if (formValue.isFileItem()) {
                                formItemList.add(new FormItem(null, formValue.getCharset(), formValue.isFileItem(), formValue.getFileItem().getInputStream()));
                                continue;
                            }
                            formItemList.add(new FormItem(formValue.getValue(), formValue.getCharset(), formValue.isFileItem(), null));
                        }
                    }
                    httpRequest = new UndertowRequest(httpServerExchange, new HttpRequestBodyContent(contentType, null, formItemPerKeyMap));
                }
                byte[] content = httpServerExchange.getInputStream().readAllBytes();
                httpRequest = new UndertowRequest(httpServerExchange, new HttpRequestBodyContent(contentType, content, null));
            }
            catch (IOException exception) {
                return Either.ofRight((Object)new HttpException.BadRequest("Can't parse body content", exception));
            }
        } else {
            httpRequest = this.createHttpRequestWithoutBodyContent(httpServerExchange);
        }
        return Either.ofLeft((Object)httpRequest);
    }

    private HttpRequest createHttpRequestWithoutBodyContent(HttpServerExchange httpServerExchange) {
        return new UndertowRequest(httpServerExchange, new HttpRequestBodyContent(null, null, null));
    }
}

