/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import com.fasterxml.jackson.databind.JsonNode;
import dev.voidframework.core.utils.IOUtils;
import dev.voidframework.core.utils.JsonUtils;
import dev.voidframework.core.utils.ReflectionUtils;
import dev.voidframework.core.utils.XmlUtils;
import dev.voidframework.core.utils.YamlUtils;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.FormData;
import dev.voidframework.web.http.FormItem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;

public record HttpRequestBodyContent(String contentType, InputStream asRaw, FormData asFormData) {
    public <T> T as(Class<T> outputClass) {
        Object object = switch (this.contentType()) {
            case "application/json" -> JsonUtils.fromJson((InputStream)this.asRaw, outputClass);
            case "application/x-www-form-urlencoded", "multipart/form-data" -> this.asFormData(outputClass);
            case "application/xml" -> XmlUtils.fromXml((InputStream)this.asRaw, outputClass);
            case "text/yaml" -> YamlUtils.fromYaml((InputStream)this.asRaw, outputClass);
            default -> throw new HttpException.BadRequest("Unhandled body content");
        };
        IOUtils.resetWithoutException((InputStream)this.asRaw);
        return object;
    }

    public <T> T asFormData(Class<T> outputClass) {
        HashMap<String, String> flatValueMap = new HashMap<String, String>();
        HashMap<String, InputStream> flatFileMap = new HashMap<String, InputStream>();
        for (Map.Entry entry : this.asFormData.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            if (!((FormItem)((List)entry.getValue()).get(0)).isFile()) {
                flatValueMap.put((String)entry.getKey(), ((FormItem)((List)entry.getValue()).get(0)).value());
                continue;
            }
            flatFileMap.put((String)entry.getKey(), ((FormItem)((List)entry.getValue()).get(0)).inputStream());
        }
        Object output = JsonUtils.fromMap(flatValueMap, outputClass);
        for (Map.Entry entry : flatFileMap.entrySet()) {
            ReflectionUtils.setFieldValue((Object)output, (String)((String)entry.getKey()), entry.getValue());
        }
        return (T)output;
    }

    public JsonNode asJson() {
        JsonNode node = JsonUtils.toJson((InputStream)this.asRaw);
        IOUtils.resetWithoutException((InputStream)this.asRaw);
        return node;
    }

    public Document asXml() {
        Document document = XmlUtils.toXml((InputStream)this.asRaw);
        IOUtils.resetWithoutException((InputStream)this.asRaw);
        return document;
    }

    public JsonNode asYaml() {
        JsonNode node = YamlUtils.toYaml((InputStream)this.asRaw);
        IOUtils.resetWithoutException((InputStream)this.asRaw);
        return node;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequestBodyContent that = (HttpRequestBodyContent)o;
        return Objects.equals(this.contentType, that.contentType) && this.asRaw == that.asRaw && Objects.equals(this.asFormData, that.asFormData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.contentType, this.asFormData);
    }

    @Override
    public String toString() {
        return "HttpRequestBodyContent{contentType='" + this.contentType + "'}";
    }
}

