/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http.controller;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.HttpMethod;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.annotation.NoCSRF;
import dev.voidframework.web.http.annotation.RequestPath;
import dev.voidframework.web.http.annotation.RequestRoute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStaticAssetsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStaticAssetsController.class);
    private final boolean runInDevMode;
    private final String baseAssetResourcesDirectory;
    private final Tika tika;

    @Inject
    protected AbstractStaticAssetsController(Config configuration) {
        this.runInDevMode = configuration.getBoolean("voidframework.core.runInDevMode");
        this.baseAssetResourcesDirectory = configuration.getString("voidframework.web.baseAssetResourcesDirectory");
        this.tika = new Tika();
    }

    @NoCSRF
    @RequestRoute(method=HttpMethod.GET, route="/webjars/(?<fileName>.*)")
    public Result webjarAsset(@RequestPath(value="fileName") String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName) || fileName.contains("..")) {
            throw new HttpException.NotFound();
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/resources/webjars/" + fileName);
        if (inputStream == null) {
            throw new HttpException.NotFound();
        }
        String contentType = this.detectFileContentType(fileName);
        return Result.ok(inputStream, contentType).withHeader("Cache-Control", "public, max-age=3600;");
    }

    @NoCSRF
    @RequestRoute(method=HttpMethod.GET, route="/(favicon.ico|robots.txt)")
    public Result staticAsset(Context context) {
        return this.staticAsset(context.getRequest().getRequestURI());
    }

    @NoCSRF
    @RequestRoute(method=HttpMethod.GET, route="/static/(?<fileName>.*)")
    public Result staticAsset(@RequestPath(value="fileName") String fileName) {
        Path fileLocation;
        if (StringUtils.isBlank((CharSequence)fileName) || fileName.contains("..")) {
            throw new HttpException.NotFound();
        }
        InputStream inputStream = null;
        String contentType = null;
        if (this.runInDevMode && (fileLocation = this.resolveLocation(fileName)) != null) {
            try {
                inputStream = Files.newInputStream(fileLocation, new OpenOption[0]);
                contentType = this.detectFileContentType(fileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            Object requestedFileName = Paths.get(this.baseAssetResourcesDirectory, fileName).toString();
            if (((String)requestedFileName).charAt(0) != File.separatorChar) {
                requestedFileName = File.separator + (String)requestedFileName;
            }
            if ((inputStream = this.getClass().getResourceAsStream(((String)requestedFileName).replace(File.separator, "/"))) == null) {
                throw new HttpException.NotFound();
            }
            contentType = this.detectFileContentType((String)requestedFileName);
        }
        return Result.ok(inputStream, contentType).withHeader("Cache-Control", "public, max-age=3600;");
    }

    private String detectFileContentType(String fileName) {
        String contentType = this.tika.detect(fileName);
        if (contentType == null) {
            LOGGER.warn("Can't determine Content-Type for '{}', defaulting to '{}'", (Object)fileName, (Object)"application/octet-stream");
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private Path resolveLocation(String fileName) {
        Path path2;
        block9: {
            Path rootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path resolvePath = Path.of("src", "main", "resources", this.baseAssetResourcesDirectory, fileName);
            Path firstPossibleLocation = rootPath.resolve(resolvePath);
            if (firstPossibleLocation.toFile().exists()) {
                return firstPossibleLocation;
            }
            Stream<Path> stream = Files.walk(rootPath, 1, new FileVisitOption[0]);
            try {
                path2 = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(path -> path.resolve(resolvePath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(null);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    return null;
                }
            }
            stream.close();
        }
        return path2;
    }
}

