/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

abstract class AbstractModificationTrackingHashMap
extends HashMap<String, String> {
    protected transient boolean isModified;

    protected AbstractModificationTrackingHashMap() {
    }

    protected AbstractModificationTrackingHashMap(Map<String, String> data) {
        super(data);
    }

    @Override
    public String remove(Object key) {
        this.isModified = true;
        return (String)super.remove(key);
    }

    @Override
    public String put(String key, String value) {
        this.isModified = true;
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> values) {
        this.isModified = true;
        super.putAll(values);
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.isModified = true;
            super.clear();
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractModificationTrackingHashMap that = (AbstractModificationTrackingHashMap)o;
        return this.isModified == that.isModified;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isModified);
    }
}

