/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import dev.voidframework.core.conversion.Conversion;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

abstract class AbstractHttpRequestHandler {
    private static final Map<Class<?>, PrimitiveAlternative> PRIMITIVE_ALTERNATIVE_MAP = Map.ofEntries(Map.entry(Boolean.TYPE, new PrimitiveAlternative(Boolean.class, false)), Map.entry(Byte.TYPE, new PrimitiveAlternative(Byte.class, 0)), Map.entry(Character.TYPE, new PrimitiveAlternative(Character.class, 0)), Map.entry(Double.TYPE, new PrimitiveAlternative(Double.class, 0.0)), Map.entry(Float.TYPE, new PrimitiveAlternative(Float.class, Float.valueOf(0.0f))), Map.entry(Integer.TYPE, new PrimitiveAlternative(Integer.class, 0)), Map.entry(Long.TYPE, new PrimitiveAlternative(Long.class, 0)), Map.entry(Short.TYPE, new PrimitiveAlternative(Short.class, 0)));
    private final Conversion conversion;

    AbstractHttpRequestHandler(Conversion conversion) {
        this.conversion = conversion;
    }

    protected Object convertValueToParameterType(String value, Class<?> parameterTypeClass) {
        Object converterValue;
        Class<?> clazzToUse = parameterTypeClass;
        Object defaultValue = null;
        if (parameterTypeClass == String.class) {
            return value;
        }
        PrimitiveAlternative primitiveAlternative = PRIMITIVE_ALTERNATIVE_MAP.get(parameterTypeClass);
        if (primitiveAlternative != null) {
            clazzToUse = primitiveAlternative.replacementClass;
            defaultValue = primitiveAlternative.defaultValue;
        }
        return (converterValue = this.conversion.convert((Object)value, clazzToUse)) != null ? converterValue : defaultValue;
    }

    protected Object convertValuesToParameterTypeArray(List<String> valueList, Class<?> parameterTypeClass) {
        if (valueList == null) {
            return null;
        }
        Object target = Array.newInstance(parameterTypeClass, valueList.size());
        int idx = 0;
        for (String value : valueList) {
            Array.set(target, idx, this.convertValueToParameterType(value, parameterTypeClass));
            ++idx;
        }
        return target;
    }

    private record PrimitiveAlternative(Class<?> replacementClass, Object defaultValue) {
    }
}

