/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import com.google.inject.Injector;
import dev.voidframework.core.conversion.Conversion;
import dev.voidframework.web.http.HttpMethod;
import dev.voidframework.web.http.WebSocketContext;
import dev.voidframework.web.http.annotation.RequestPath;
import dev.voidframework.web.http.annotation.RequestVariable;
import dev.voidframework.web.http.routing.ResolvedRoute;
import dev.voidframework.web.http.routing.Router;
import dev.voidframework.web.server.http.AbstractHttpRequestHandler;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.lang.reflect.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpWebSocketRequestHandler
extends AbstractHttpRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpWebSocketRequestHandler.class);
    private final Injector injector;
    private final Router router;

    public HttpWebSocketRequestHandler(Injector injector) {
        super((Conversion)injector.getInstance(Conversion.class));
        this.injector = injector;
        this.router = (Router)this.injector.getInstance(Router.class);
    }

    public void onIncomingConnection(WebSocketContext context) throws IOException {
        ResolvedRoute resolvedRoute = this.router.resolveRoute(HttpMethod.WEBSOCKET, context.getRequest().getRequestURI());
        if (resolvedRoute == null) {
            context.getChannel().sendClose();
            return;
        }
        Object controllerInstance = this.injector.getInstance(resolvedRoute.controllerClassType());
        Object[] methodArgumentValueArray = this.buildMethodArguments(context, resolvedRoute);
        try {
            resolvedRoute.method().invoke(controllerInstance, methodArgumentValueArray);
        }
        catch (Exception exception) {
            LOGGER.error("Something wrong occurred when handling incoming WebSocket connection", (Throwable)exception);
            context.getChannel().sendClose();
        }
    }

    private Object[] buildMethodArguments(WebSocketContext context, ResolvedRoute resolvedRoute) {
        int idx = 0;
        Object[] methodArgumentValueArray = new Object[resolvedRoute.method().getParameterCount()];
        for (Parameter parameter : resolvedRoute.method().getParameters()) {
            if (parameter.getType().isAssignableFrom(WebSocketContext.class)) {
                methodArgumentValueArray[idx] = context;
            } else if (parameter.getType().isAssignableFrom(WebSocketChannel.class)) {
                methodArgumentValueArray[idx] = context.getChannel();
            } else {
                RequestPath requestPath = parameter.getAnnotation(RequestPath.class);
                RequestVariable requestVariable = parameter.getAnnotation(RequestVariable.class);
                methodArgumentValueArray[idx] = requestPath != null ? this.convertValueToParameterType(resolvedRoute.extractedParameterValues().getOrDefault(requestPath.value(), null), parameter.getType()) : (requestVariable != null ? this.convertValueToParameterType(context.getRequest().getQueryStringParameter(requestVariable.value()), parameter.getType()) : this.injector.getInstance(parameter.getType()));
            }
            ++idx;
        }
        return methodArgumentValueArray;
    }
}

