/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import dev.voidframework.web.http.Session;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionSigner.class);
    private static final List<String> SESSION_INTERNAL_KEY_LIST = Arrays.asList("exp", "iat", "nbf");
    private final SessionSignerConfiguration sessionSignerConfiguration;
    private final JWTVerifier verifier;

    public SessionSigner(Config configuration) {
        this.sessionSignerConfiguration = new SessionSignerConfiguration(configuration.getString("voidframework.web.session.signatureKey"), configuration.getDuration("voidframework.web.session.timeToLive"));
        if (this.sessionSignerConfiguration.signatureKey.equalsIgnoreCase("changeme") || StringUtils.isBlank((CharSequence)this.sessionSignerConfiguration.signatureKey)) {
            throw new ConfigException.BadValue("voidframework.web.session.signatureKey", "Please configure the Session signature Key");
        }
        JWTVerifier.BaseVerification verification = (JWTVerifier.BaseVerification)JWT.require((Algorithm)Algorithm.HMAC256((String)this.sessionSignerConfiguration.signatureKey)).acceptLeeway(5L).acceptExpiresAt(5L);
        this.verifier = verification.build();
    }

    public Session verify(String signedSession) {
        try {
            DecodedJWT decodedJWT = this.verifier.verify(signedSession);
            HashMap<String, String> sessionContent = new HashMap<String, String>();
            for (Map.Entry claim : decodedJWT.getClaims().entrySet()) {
                if (SESSION_INTERNAL_KEY_LIST.contains(claim.getKey())) continue;
                sessionContent.put((String)claim.getKey(), ((Claim)claim.getValue()).asString());
            }
            return new Session((Map<String, String>)sessionContent);
        }
        catch (JWTVerificationException jWTVerificationException) {
            return new Session();
        }
    }

    public String sign(Session session) {
        try {
            Instant instantUtc = Instant.now();
            Date dateNowUtc = Date.from(instantUtc);
            Date dateExpirationUtc = Date.from(instantUtc.plus(this.sessionSignerConfiguration.timeToLive));
            return JWT.create().withIssuedAt(dateNowUtc).withNotBefore(dateNowUtc).withExpiresAt(dateExpirationUtc).withPayload((Map)session).sign(Algorithm.HMAC256((String)this.sessionSignerConfiguration.signatureKey));
        }
        catch (JWTCreationException | IllegalArgumentException exception) {
            LOGGER.error("Can't sign session", exception);
            return null;
        }
    }

    private record SessionSignerConfiguration(String signatureKey, Duration timeToLive) {
    }
}

