/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http.routing;

public record RouteURL(String url) {
    public static RouteURL of(String route) {
        String cleanedRoute = RouteURL.cleanRoutePath(route);
        return new RouteURL(cleanedRoute);
    }

    public static RouteURL of(String contextPath, String prefix, String route) {
        String cleanedContextPath = RouteURL.cleanContextPath(contextPath);
        String cleanedPrefix = RouteURL.cleanRoutePath(prefix);
        String cleanedRoute = RouteURL.cleanRoutePath(route);
        if (cleanedPrefix.endsWith("/") && cleanedRoute.charAt(0) == '/') {
            return new RouteURL(RouteURL.cleanRoutePath(cleanedContextPath + cleanedPrefix + cleanedRoute.substring(1)));
        }
        return new RouteURL(RouteURL.cleanRoutePath(cleanedContextPath + cleanedPrefix + cleanedRoute));
    }

    private static String cleanContextPath(String contextPath) {
        if (contextPath == null) {
            return "";
        }
        Object cleanedContextPath = contextPath.trim();
        if (((String)cleanedContextPath).isEmpty() || ((String)cleanedContextPath).equals("/")) {
            return "";
        }
        if (((String)cleanedContextPath).charAt(0) != '/') {
            cleanedContextPath = "/" + (String)cleanedContextPath;
        }
        if (((String)cleanedContextPath).endsWith("/")) {
            cleanedContextPath = ((String)cleanedContextPath).substring(0, ((String)cleanedContextPath).length() - 1);
        }
        return cleanedContextPath;
    }

    private static String cleanRoutePath(String routePath) {
        if (routePath == null) {
            return "";
        }
        Object cleanedRoutePath = routePath.trim();
        if (((String)cleanedRoutePath).isEmpty() || ((String)cleanedRoutePath).equals("/")) {
            return "/";
        }
        if (((String)cleanedRoutePath).charAt(0) != '/') {
            cleanedRoutePath = "/" + (String)cleanedRoutePath;
        }
        if (((String)cleanedRoutePath).endsWith("/")) {
            cleanedRoutePath = ((String)cleanedRoutePath).substring(0, ((String)cleanedRoutePath).length() - 1);
        }
        return cleanedRoutePath;
    }

    @Override
    public String toString() {
        return this.url;
    }
}

