/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import com.fasterxml.jackson.databind.JsonNode;
import dev.voidframework.core.utils.JsonUtils;
import dev.voidframework.web.http.Cookie;
import dev.voidframework.web.http.TemplateResult;
import dev.voidframework.web.http.resultprocessor.NoContentResultProcessor;
import dev.voidframework.web.http.resultprocessor.ObjectResultProcessor;
import dev.voidframework.web.http.resultprocessor.ResultProcessor;
import dev.voidframework.web.http.resultprocessor.TemplateResultProcessor;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class Result {
    private static final String CONTENT_TYPE_CHARSET = "; charset=";
    private static final NoContentResultProcessor NO_CONTENT_RESULT_PROCESSOR = new NoContentResultProcessor();
    private static final String NO_CONTENT_TYPE = null;
    private final int httpCode;
    private final String contentType;
    private final ResultProcessor resultProcessor;
    private final Map<String, String> headerMap;
    private final Map<String, Cookie> cookieMap;

    public Result() {
        this.httpCode = -1;
        this.resultProcessor = null;
        this.contentType = null;
        this.headerMap = Map.of();
        this.cookieMap = Map.of();
    }

    private Result(int httpCode, ResultProcessor resultProcessor, String contentType) {
        this.httpCode = httpCode;
        this.resultProcessor = resultProcessor;
        this.contentType = contentType;
        this.headerMap = new HashMap<String, String>();
        this.cookieMap = new HashMap<String, Cookie>();
    }

    public static Result badRequest() {
        return new Result(400, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result badRequest(String content) {
        return Result.badRequest(content, "text/html", StandardCharsets.UTF_8);
    }

    public static Result badRequest(String content, String contentType, Charset charset) {
        return new Result(400, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result badRequest(byte[] content, String contentType) {
        return new Result(400, new ObjectResultProcessor(content), contentType);
    }

    public static Result badRequest(byte[] content, String contentType, Charset charset) {
        return new Result(400, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result badRequest(JsonNode content) {
        return new Result(400, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result badRequest(TemplateResult templateResult) {
        return new Result(400, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result created() {
        return new Result(201, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result created(String content) {
        return new Result(201, new ObjectResultProcessor(content), "text/html");
    }

    public static Result created(String content, String contentType) {
        return Result.created(content, contentType, StandardCharsets.UTF_8);
    }

    public static Result created(String content, String contentType, Charset charset) {
        return new Result(201, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result created(byte[] content, String contentType) {
        return new Result(201, new ObjectResultProcessor(content), contentType);
    }

    public static Result created(byte[] content, String contentType, Charset charset) {
        return new Result(201, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result created(JsonNode content) {
        return new Result(201, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result created(TemplateResult templateResult) {
        return new Result(201, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result forbidden() {
        return new Result(403, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result forbidden(String content) {
        return Result.forbidden(content, "text/html", StandardCharsets.UTF_8);
    }

    public static Result forbidden(String content, String contentType) {
        return new Result(403, new ObjectResultProcessor(content), contentType);
    }

    public static Result forbidden(String content, String contentType, Charset charset) {
        return new Result(403, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset);
    }

    public static Result forbidden(byte[] content, String contentType) {
        return new Result(403, new ObjectResultProcessor(content), contentType);
    }

    public static Result forbidden(byte[] content, String contentType, Charset charset) {
        return new Result(403, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result forbidden(JsonNode content) {
        return new Result(403, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result forbidden(TemplateResult templateResult) {
        return new Result(403, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result internalServerError() {
        return new Result(500, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result internalServerError(String content) {
        return Result.internalServerError(content, "text/html", StandardCharsets.UTF_8);
    }

    public static Result internalServerError(String content, String contentType) {
        return new Result(500, new ObjectResultProcessor(content), contentType);
    }

    public static Result internalServerError(String content, String contentType, Charset charset) {
        return new Result(500, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result internalServerError(byte[] content, String contentType) {
        return new Result(500, new ObjectResultProcessor(content), contentType);
    }

    public static Result internalServerError(byte[] content, String contentType, Charset charset) {
        return new Result(500, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset);
    }

    public static Result internalServerError(JsonNode content) {
        return new Result(500, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result internalServerError(TemplateResult templateResult) {
        return new Result(404, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result noContent() {
        return new Result(204, NO_CONTENT_RESULT_PROCESSOR, NO_CONTENT_TYPE);
    }

    public static Result notFound() {
        return new Result(404, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result notFound(String content) {
        return Result.notFound(content, "text/html", StandardCharsets.UTF_8);
    }

    public static Result notFound(String content, String contentType) {
        return new Result(404, new ObjectResultProcessor(content), contentType);
    }

    public static Result notFound(String content, String contentType, Charset charset) {
        return new Result(404, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result notFound(byte[] content, String contentType) {
        return new Result(404, new ObjectResultProcessor(content), contentType);
    }

    public static Result notFound(byte[] content, String contentType, Charset charset) {
        return new Result(404, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result notFound(JsonNode content) {
        return new Result(404, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result notFound(TemplateResult templateResult) {
        return new Result(404, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result notImplemented() {
        return new Result(501, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result notImplemented(String content) {
        return Result.notImplemented(content, "text/html", StandardCharsets.UTF_8);
    }

    public static Result notImplemented(String content, String contentType) {
        return new Result(501, new ObjectResultProcessor(content), contentType);
    }

    public static Result notImplemented(String content, String contentType, Charset charset) {
        return new Result(501, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result notImplemented(byte[] content, String contentType) {
        return new Result(501, new ObjectResultProcessor(content), contentType);
    }

    public static Result notImplemented(byte[] content, String contentType, Charset charset) {
        return new Result(501, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result notImplemented(JsonNode content) {
        return new Result(501, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result notImplemented(TemplateResult templateResult) {
        return new Result(501, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result ok() {
        return new Result(200, NO_CONTENT_RESULT_PROCESSOR, "text/html");
    }

    public static Result ok(String content) {
        return Result.ok(content, "text/html", StandardCharsets.UTF_8);
    }

    public static Result ok(String content, String contentType) {
        return new Result(200, new ObjectResultProcessor(content), contentType);
    }

    public static Result ok(String content, String contentType, Charset charset) {
        return new Result(200, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result ok(byte[] content, String contentType) {
        return new Result(200, new ObjectResultProcessor(content), contentType);
    }

    public static Result ok(byte[] content, String contentType, Charset charset) {
        return new Result(200, new ObjectResultProcessor(content), contentType + CONTENT_TYPE_CHARSET + charset.name());
    }

    public static Result ok(InputStream content, String contentType) {
        return new Result(200, new ObjectResultProcessor(content), contentType);
    }

    public static Result ok(JsonNode content) {
        return new Result(200, new ObjectResultProcessor(JsonUtils.toString((JsonNode)content)), "application/json");
    }

    public static Result ok(TemplateResult templateResult) {
        return new Result(200, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result redirectMovedPermanently(String uri) {
        return new Result(301, NO_CONTENT_RESULT_PROCESSOR, NO_CONTENT_TYPE).withHeader("Location", uri);
    }

    public static Result redirectPermanentRedirect(String uri) {
        return new Result(308, NO_CONTENT_RESULT_PROCESSOR, NO_CONTENT_TYPE).withHeader("Location", uri);
    }

    public static Result redirectFound(String uri) {
        return new Result(302, NO_CONTENT_RESULT_PROCESSOR, NO_CONTENT_TYPE).withHeader("Location", uri);
    }

    public static Result redirectSeeOther(String uri) {
        return new Result(303, NO_CONTENT_RESULT_PROCESSOR, NO_CONTENT_TYPE).withHeader("Location", uri);
    }

    public static Result redirectTemporaryRedirect(String uri) {
        return new Result(307, NO_CONTENT_RESULT_PROCESSOR, NO_CONTENT_TYPE).withHeader("Location", uri);
    }

    public Result withCookie(Cookie cookie) {
        this.cookieMap.put(cookie.name(), cookie);
        return this;
    }

    public Result withoutCookie(Cookie cookie) {
        return this.withoutCookie(cookie.name());
    }

    public Result withoutCookie(String cookieName) {
        this.cookieMap.put(cookieName, Cookie.expired(cookieName));
        return this;
    }

    public Result withHeader(String headerName, String value) {
        this.headerMap.put(headerName, value);
        return this;
    }

    public Result withHeaders(Map<String, String> headerMap) {
        this.headerMap.putAll(headerMap);
        return this;
    }

    public Result withoutHeader(String headerName) {
        this.headerMap.remove(headerName);
        return this;
    }

    public Map<String, Cookie> getCookies() {
        return this.cookieMap;
    }

    public Map<String, String> getHeaders() {
        return this.headerMap;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }
}

