/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.module;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import dev.voidframework.web.bindable.WebController;
import dev.voidframework.web.http.annotation.RequestRoute;
import dev.voidframework.web.http.routing.RouteURL;
import dev.voidframework.web.http.routing.Router;
import java.lang.reflect.Method;

public class ControllerAnnotationListener
implements TypeListener {
    private final String contextPath;
    private final Router router;

    public ControllerAnnotationListener(String contextPath, Router router) {
        this.contextPath = contextPath;
        this.router = router;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class classType = type.getRawType();
        WebController webController = classType.getAnnotation(WebController.class);
        if (webController != null) {
            for (Method method : classType.getMethods()) {
                if (!method.isAnnotationPresent(RequestRoute.class)) continue;
                RequestRoute requestRoute = method.getAnnotation(RequestRoute.class);
                RouteURL routeURL = RouteURL.of(this.contextPath, webController.prefixRoute(), requestRoute.route());
                this.router.addRoute(requestRoute.method(), routeURL, classType, method, requestRoute.name());
            }
        }
    }
}

