/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import dev.voidframework.web.http.WebSocketRequest;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class UndertowWebSocketRequest
implements WebSocketRequest {
    private final WebSocketHttpExchange webSocketHttpExchange;
    private Map<String, List<String>> headerMapCache;
    private Map<String, List<String>> queryStringValuesMapCache;

    public UndertowWebSocketRequest(WebSocketHttpExchange webSocketHttpExchange) {
        this.webSocketHttpExchange = webSocketHttpExchange;
    }

    @Override
    public boolean acceptContentType(String contentType) {
        List acceptHeaderValuesList = (List)this.webSocketHttpExchange.getRequestHeaders().get("Accept");
        if (acceptHeaderValuesList == null || acceptHeaderValuesList.isEmpty()) {
            return false;
        }
        for (String value : ((String)acceptHeaderValuesList.get(0)).split(",")) {
            if (!value.contains(contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getHeader(String headerName) {
        List headerValuesList = (List)this.webSocketHttpExchange.getRequestHeaders().get(headerName);
        if (headerValuesList == null || headerValuesList.isEmpty()) {
            return null;
        }
        return (String)headerValuesList.get(0);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headerMapCache == null) {
            this.headerMapCache = new HashMap<String, List<String>>();
            this.headerMapCache.putAll(this.webSocketHttpExchange.getRequestHeaders());
        }
        return this.headerMapCache;
    }

    @Override
    public String getQueryString() {
        return this.webSocketHttpExchange.getQueryString();
    }

    @Override
    public Map<String, List<String>> getQueryStringParameters() {
        if (this.queryStringValuesMapCache == null) {
            this.queryStringValuesMapCache = this.parseQueryStringParameters();
        }
        return this.queryStringValuesMapCache;
    }

    @Override
    public String getQueryStringParameter(String parameterName) {
        List<String> queryStringValue;
        if (parameterName == null) {
            return null;
        }
        if (this.queryStringValuesMapCache == null) {
            this.queryStringValuesMapCache = this.parseQueryStringParameters();
        }
        if ((queryStringValue = this.queryStringValuesMapCache.get(parameterName)) == null || queryStringValue.isEmpty()) {
            return null;
        }
        return queryStringValue.get(0);
    }

    @Override
    public String getQueryStringParameter(String parameterName, String fallbackValue) {
        String value = this.getQueryStringParameter(parameterName);
        return StringUtils.isBlank((CharSequence)value) ? fallbackValue : value;
    }

    @Override
    public String getRequestURI() {
        return this.webSocketHttpExchange.getRequestURI();
    }

    private Map<String, List<String>> parseQueryStringParameters() {
        String[] pairArray;
        HashMap<String, List<String>> queryStringValuesMap = new HashMap<String, List<String>>();
        for (String pair : pairArray = this.webSocketHttpExchange.getQueryString().split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
            if (!queryStringValuesMap.containsKey(key)) {
                queryStringValuesMap.put(key, new ArrayList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8) : null;
            ((List)queryStringValuesMap.get(key)).add(value);
        }
        return queryStringValuesMap;
    }
}

