/*
 * Decompiled with CFR 0.152.
 */
package dk.trustworks.essentials.components.queue.postgresql;

import dk.trustworks.essentials.components.foundation.json.JSONSerializer;
import dk.trustworks.essentials.components.foundation.json.JacksonJSONSerializer;
import dk.trustworks.essentials.components.foundation.messaging.queue.QueuePollingOptimizer;
import dk.trustworks.essentials.components.foundation.messaging.queue.TransactionalMode;
import dk.trustworks.essentials.components.foundation.messaging.queue.operations.ConsumeFromQueue;
import dk.trustworks.essentials.components.foundation.postgresql.MultiTableChangeListener;
import dk.trustworks.essentials.components.foundation.postgresql.TableChangeNotification;
import dk.trustworks.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWork;
import dk.trustworks.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWorkFactory;
import dk.trustworks.essentials.components.queue.postgresql.PostgresqlDurableQueues;
import java.time.Duration;
import java.util.function.Function;

public final class PostgresqlDurableQueuesBuilder {
    private HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory;
    private JSONSerializer jsonSerializer;
    private String sharedQueueTableName = "durable_queues";
    private MultiTableChangeListener<TableChangeNotification> multiTableChangeListener = null;
    private Function<ConsumeFromQueue, QueuePollingOptimizer> queuePollingOptimizerFactory = null;
    private TransactionalMode transactionalMode = TransactionalMode.SingleOperationTransaction;
    private Duration messageHandlingTimeout = Duration.ofSeconds(30L);
    private boolean useCentralizedMessageFetcher = true;
    private Duration centralizedMessageFetcherPollingInterval = Duration.ofMillis(20L);

    public PostgresqlDurableQueuesBuilder setUnitOfWorkFactory(HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory) {
        this.unitOfWorkFactory = unitOfWorkFactory;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setJsonSerializer(JSONSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setSharedQueueTableName(String sharedQueueTableName) {
        this.sharedQueueTableName = sharedQueueTableName;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setMultiTableChangeListener(MultiTableChangeListener<TableChangeNotification> multiTableChangeListener) {
        this.multiTableChangeListener = multiTableChangeListener;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setQueuePollingOptimizerFactory(Function<ConsumeFromQueue, QueuePollingOptimizer> queuePollingOptimizerFactory) {
        this.queuePollingOptimizerFactory = queuePollingOptimizerFactory;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setMessageHandlingTimeout(Duration messageHandlingTimeout) {
        this.messageHandlingTimeout = messageHandlingTimeout;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setTransactionalMode(TransactionalMode transactionalMode) {
        this.transactionalMode = transactionalMode;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setUseCentralizedMessageFetcher(boolean useCentralizedMessageFetcher) {
        this.useCentralizedMessageFetcher = useCentralizedMessageFetcher;
        return this;
    }

    public PostgresqlDurableQueuesBuilder setCentralizedMessageFetcherPollingInterval(Duration centralizedMessageFetcherPollingInterval) {
        this.centralizedMessageFetcherPollingInterval = centralizedMessageFetcherPollingInterval;
        return this;
    }

    public PostgresqlDurableQueues build() {
        return new PostgresqlDurableQueues(this.unitOfWorkFactory, (JSONSerializer)(this.jsonSerializer != null ? this.jsonSerializer : new JacksonJSONSerializer(PostgresqlDurableQueues.createDefaultObjectMapper())), this.sharedQueueTableName, this.multiTableChangeListener, this.queuePollingOptimizerFactory, this.transactionalMode, this.messageHandlingTimeout, this.useCentralizedMessageFetcher, this.centralizedMessageFetcherPollingInterval);
    }
}

