/*
 * Decompiled with CFR 0.152.
 */
package dk.trustworks.essentials.components.queue.postgresql;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dk.trustworks.essentials.components.foundation.json.JSONSerializer;
import dk.trustworks.essentials.components.foundation.messaging.queue.DurableQueueDeserializationException;
import dk.trustworks.essentials.components.foundation.messaging.queue.MessageMetaData;
import dk.trustworks.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.trustworks.essentials.components.foundation.messaging.queue.QueueName;
import dk.trustworks.essentials.jackson.immutable.EssentialsImmutableJacksonModule;
import dk.trustworks.essentials.jackson.types.EssentialTypesJacksonModule;
import dk.trustworks.essentials.shared.Exceptions;
import dk.trustworks.essentials.shared.FailFast;
import dk.trustworks.essentials.shared.MessageFormatter;

public class DurableQueuesSerialization {
    private final JSONSerializer jsonSerializer;

    public DurableQueuesSerialization(JSONSerializer jsonSerializer) {
        this.jsonSerializer = (JSONSerializer)FailFast.requireNonNull((Object)jsonSerializer, (String)"No jsonSerializer provided");
    }

    public Object deserializeMessagePayload(QueueName queueName, QueueEntryId queueEntryId, String messagePayload, String messagePayloadType) {
        FailFast.requireNonNull((Object)queueName, (String)"No queueName provided");
        FailFast.requireNonNull((Object)queueEntryId, (String)"No queueEntryId provided");
        FailFast.requireNonNull((Object)messagePayload, (String)"No messagePayload provided");
        FailFast.requireNonNull((Object)messagePayloadType, (String)"No messagePayloadType provided");
        try {
            return this.jsonSerializer.deserialize(messagePayload, messagePayloadType);
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new DurableQueueDeserializationException(MessageFormatter.msg((String)"Failed to deserialize message payload of type {}", (Object[])new Object[]{messagePayloadType}), e, queueName, queueEntryId);
        }
    }

    public MessageMetaData deserializeMessageMetadata(QueueName queueName, QueueEntryId queueEntryId, String metaData) {
        FailFast.requireNonNull((Object)queueName, (String)"No queueName provided");
        FailFast.requireNonNull((Object)queueEntryId, (String)"No queueEntryId provided");
        FailFast.requireNonNull((Object)metaData, (String)"No messagePayload provided");
        try {
            return (MessageMetaData)this.jsonSerializer.deserialize(metaData, MessageMetaData.class);
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new DurableQueueDeserializationException(MessageFormatter.msg((String)"Failed to deserialize message meta-data", (Object[])new Object[0]), e, queueName, queueEntryId);
        }
    }

    public static ObjectMapper createDefaultObjectMapper() {
        JsonMapper objectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS})).disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS})).enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS})).enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER})).addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).addModule((Module)new EssentialTypesJacksonModule())).addModule((Module)new EssentialsImmutableJacksonModule())).build();
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
        return objectMapper;
    }
}

