/*
 * Decompiled with CFR 0.152.
 */
package dk.trustworks.essentials.components.queue.postgresql;

import dk.trustworks.essentials.components.foundation.messaging.queue.DefaultQueuedMessage;
import dk.trustworks.essentials.components.foundation.messaging.queue.Message;
import dk.trustworks.essentials.components.foundation.messaging.queue.MessageMetaData;
import dk.trustworks.essentials.components.foundation.messaging.queue.OrderedMessage;
import dk.trustworks.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.trustworks.essentials.components.foundation.messaging.queue.QueueName;
import dk.trustworks.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.trustworks.essentials.shared.MessageFormatter;
import dk.trustworks.essentials.shared.functional.QuadFunction;
import dk.trustworks.essentials.shared.functional.TripleFunction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class QueuedMessageRowMapper
implements RowMapper<QueuedMessage> {
    private final TripleFunction<QueueName, QueueEntryId, String, MessageMetaData> metadataDeserializer;
    private final QuadFunction<QueueName, QueueEntryId, String, String, Object> payloadDeserializer;

    public QueuedMessageRowMapper(QuadFunction<QueueName, QueueEntryId, String, String, Object> payloadDeserializer, TripleFunction<QueueName, QueueEntryId, String, MessageMetaData> metadataDeserializer) {
        this.payloadDeserializer = payloadDeserializer;
        this.metadataDeserializer = metadataDeserializer;
    }

    public QueuedMessage map(ResultSet rs, StatementContext ctx) throws SQLException {
        QueueName queueName = QueueName.of((CharSequence)rs.getString("queue_name"));
        QueueEntryId queueEntryId = QueueEntryId.of((CharSequence)rs.getString("id"));
        Object messagePayload = this.payloadDeserializer.apply((Object)queueName, (Object)queueEntryId, (Object)rs.getString("message_payload"), (Object)rs.getString("message_payload_type"));
        MessageMetaData messageMetaData = null;
        String metaDataColumnValue = rs.getString("meta_data");
        messageMetaData = metaDataColumnValue != null ? (MessageMetaData)this.metadataDeserializer.apply((Object)queueName, (Object)queueEntryId, (Object)metaDataColumnValue) : new MessageMetaData();
        QueuedMessage.DeliveryMode deliveryMode = QueuedMessage.DeliveryMode.valueOf((String)rs.getString("delivery_mode"));
        Message message = null;
        switch (deliveryMode) {
            case NORMAL: {
                message = new Message(messagePayload, messageMetaData);
                break;
            }
            case IN_ORDER: {
                message = new OrderedMessage(messagePayload, rs.getString("key"), rs.getLong("key_order"), messageMetaData);
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormatter.msg((String)"Unsupported deliveryMode '{}'", (Object[])new Object[]{deliveryMode}));
            }
        }
        return new DefaultQueuedMessage(queueEntryId, queueName, message, rs.getObject("added_ts", OffsetDateTime.class), rs.getObject("next_delivery_ts", OffsetDateTime.class), rs.getObject("delivery_ts", OffsetDateTime.class), rs.getString("last_delivery_error"), rs.getInt("total_attempts"), rs.getInt("redelivery_attempts"), rs.getBoolean("is_dead_letter_message"), rs.getBoolean("is_being_delivered"));
    }
}

