/*
 * Decompiled with CFR 0.152.
 */
package dk.trustworks.essentials.components.queue.postgresql;

import dk.trustworks.essentials.components.foundation.messaging.queue.QueueName;
import dk.trustworks.essentials.components.foundation.postgresql.PostgresqlUtil;
import dk.trustworks.essentials.shared.MessageFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DurableQueuesSql {
    private final String sharedQueueTableName;

    public DurableQueuesSql(String sharedQueueTableName) {
        PostgresqlUtil.checkIsValidTableOrColumnName((String)sharedQueueTableName);
        this.sharedQueueTableName = sharedQueueTableName;
    }

    public String buildUnorderedSqlStatement() {
        return MessageFormatter.bind((String)"  WITH cte_unordered AS (\n    SELECT id\n    FROM {:tableName} q\n    WHERE\n         queue_name = :queueName\n      AND is_dead_letter_message = FALSE\n      AND is_being_delivered     = FALSE\n      AND next_delivery_ts <= :now\n      AND key IS NULL\n    ORDER BY next_delivery_ts\n    LIMIT :limit\n    FOR UPDATE SKIP LOCKED\n  )\n  UPDATE {:tableName} q\n  SET\n    total_attempts       = q.total_attempts + 1,\n    next_delivery_ts     = NULL,\n    is_being_delivered   = TRUE,\n    delivery_ts          = :now\n  FROM cte_unordered u\n  WHERE q.id = u.id\n    AND q.queue_name = :queueName\n  RETURNING q.*;\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String buildOrderedSqlStatement(boolean hasExclusiveKeys) {
        return MessageFormatter.bind((String)"WITH cte_ordered AS (\n           SELECT id\n           FROM {:tableName} q\n           WHERE\n                queue_name             = :queueName\n            AND is_dead_letter_message = FALSE\n            AND is_being_delivered     = FALSE\n            AND next_delivery_ts      <= :now\n\n            AND key IS NOT NULL\n\n            -- full per-key barrier:\n            AND NOT EXISTS (\n              SELECT 1\n              FROM {:tableName} q2\n              WHERE q2.key        = q.key\n                AND q2.queue_name = q.queue_name\n                AND q2.key_order  < q.key_order\n            )\n            {:excludeKeys}\n ORDER BY key_order, next_delivery_ts\n                    LIMIT :limit\n                    FOR UPDATE SKIP LOCKED\n                  )\n                  UPDATE {:tableName} q\n                  SET\n                    total_attempts       = q.total_attempts + 1,\n                    next_delivery_ts     = NULL,\n                    is_being_delivered   = TRUE,\n                    delivery_ts          = :now\n                  FROM cte_ordered o\n                  WHERE q.id = o.id\n                    AND q.queue_name = :queueName\n                  RETURNING q.*;\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName), MessageFormatter.NamedArgumentBinding.arg((String)"excludeKeys", (Object)(hasExclusiveKeys ? "AND key NOT IN (<excludeKeys>)" : ""))});
    }

    public String buildGetNextMessageReadyForDeliverySqlStatement(Collection<String> excludeOrderedMessagesWithKey) {
        Collection<String> excludedKeys;
        String excludeKeysLimitSql = "";
        Collection<String> collection = excludedKeys = excludeOrderedMessagesWithKey != null ? excludeOrderedMessagesWithKey : List.of();
        if (!excludedKeys.isEmpty()) {
            excludeKeysLimitSql = "        AND key NOT IN (<excludedKeys>)\n";
        }
        return MessageFormatter.bind((String)"WITH queued_message_ready_for_delivery AS (\n    SELECT id FROM {:tableName} q1\n    WHERE\n        queue_name = :queueName AND\n        is_dead_letter_message = FALSE AND\n        is_being_delivered = FALSE AND\n        next_delivery_ts <= :now AND\n        NOT EXISTS (SELECT 1 FROM {:tableName} q2 WHERE q2.key = q1.key AND q2.queue_name = q1.queue_name AND q2.key_order < q1.key_order)\n            {:excludeKeys}\n    ORDER BY key_order ASC, next_delivery_ts ASC\n    LIMIT :limit\n    FOR UPDATE SKIP LOCKED\n)\n        UPDATE {:tableName} queued_message SET\n            total_attempts = queued_message.total_attempts + 1,\n            next_delivery_ts = NULL,\n            is_being_delivered = TRUE,\n            delivery_ts = :now\n        FROM queued_message_ready_for_delivery\n        WHERE queued_message.id = queued_message_ready_for_delivery.id\n        AND queued_message.queue_name = :queueName\n        RETURNING\n            queued_message.id,\n            queued_message.queue_name,\n            queued_message.message_payload,\n            queued_message.message_payload_type,\n            queued_message.added_ts,\n            queued_message.next_delivery_ts,\n            queued_message.delivery_ts,\n            queued_message.last_delivery_error,\n            queued_message.total_attempts,\n            queued_message.redelivery_attempts,\n            queued_message.is_dead_letter_message,\n            queued_message.is_being_delivered,\n            queued_message.meta_data,\n            queued_message.delivery_mode,\n            queued_message.key,\n            queued_message.key_order\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName), MessageFormatter.NamedArgumentBinding.arg((String)"excludeKeys", (Object)excludeKeysLimitSql)});
    }

    public BatchedSqlResult buildBatchedSqlStatement(Map<QueueName, Set<String>> excludeKeysPerQueue, Map<QueueName, Integer> availableWorkerSlotsPerQueue, List<QueueName> activeQueues) {
        StringBuilder values = new StringBuilder();
        HashMap<String, String> singleValueBindings = new HashMap<String, String>();
        HashMap<String, Collection<String>> listBindings = new HashMap<String, Collection<String>>();
        for (int i = 0; i < activeQueues.size(); ++i) {
            QueueName queueName = activeQueues.get(i);
            Integer availableWorkerSlotsForThisQueue = availableWorkerSlotsPerQueue.get(queueName);
            Set excludedKeysForThisQueue = excludeKeysPerQueue.getOrDefault(queueName, Collections.emptySet());
            singleValueBindings.put("queueName" + i, queueName.toString());
            if (!excludedKeysForThisQueue.isEmpty()) {
                listBindings.put("excludeKeys" + i, excludedKeysForThisQueue);
            }
            if (i > 0) {
                values.append(",\n    ");
            }
            values.append("(:queueName").append(i).append(", ").append(availableWorkerSlotsForThisQueue).append(", ").append((String)(excludedKeysForThisQueue.isEmpty() ? "ARRAY[]::text[]" : ":excludeKeys" + i)).append(")");
        }
        String sql = MessageFormatter.bind((String)"WITH queue_config(queue_name, slots, exclude_keys) AS (\n    VALUES {:values}\n),\n-- 2) Numbered ordered candidates\n    ordered_rn AS (\n      SELECT\n        q.id,\n        q.queue_name,\n        ROW_NUMBER() OVER (\n          PARTITION BY q.queue_name\n          ORDER BY q.key_order, q.next_delivery_ts\n        ) AS rn\n      FROM {:tableName} q\n      JOIN queue_config cfg USING(queue_name)\n      WHERE\n           q.is_dead_letter_message = FALSE\n       AND q.is_being_delivered     = FALSE\n       AND q.next_delivery_ts      <= :now\n       AND q.key IS NOT NULL\n       AND NOT (q.key = ANY(cfg.exclude_keys))\n       AND NOT EXISTS (\n         SELECT 1\n         FROM {:tableName} q2\n         WHERE q2.queue_name = q.queue_name\n           AND q2.key        = q.key\n           AND q2.key_order  < q.key_order\n       )\n    ),\n\n    -- 3) Numbered unordered candidates\n    unordered_rn AS (\n      SELECT\n        q.id,\n        q.queue_name,\n        ROW_NUMBER() OVER (\n          PARTITION BY q.queue_name\n          ORDER BY q.next_delivery_ts\n        ) AS rn\n      FROM {:tableName} q\n      JOIN queue_config cfg USING(queue_name)\n      WHERE\n           q.is_dead_letter_message = FALSE\n       AND q.is_being_delivered     = FALSE\n       AND q.next_delivery_ts      <= :now\n       AND q.key IS NULL\n       AND NOT (q.key = ANY(cfg.exclude_keys))\n    ),\n\n    -- 4) Pick up to cfg.slots from each\n    ordered_pick AS (\n      SELECT orr.id\n      FROM ordered_rn orr\n      JOIN queue_config cfg\n        ON orr.queue_name = cfg.queue_name\n      WHERE orr.rn <= cfg.slots\n    ),\n    unordered_pick AS (\n      SELECT unr.id\n      FROM unordered_rn unr\n      JOIN queue_config cfg\n        ON unr.queue_name = cfg.queue_name\n      WHERE unr.rn <= cfg.slots\n    ),\n\n    -- 5) Union them *without locking*\n    candidates AS (\n      SELECT id FROM ordered_pick\n      UNION ALL\n      SELECT id FROM unordered_pick\n    ),\n\n    -- 6) Now lock exactly those durable_queues rows\n    locked AS (\n      SELECT q.id\n      FROM {:tableName} q\n      JOIN candidates c\n        ON q.id = c.id\n      FOR UPDATE SKIP LOCKED\n    )\n\n  -- 7) Finally, update & return the locked rows\n  UPDATE {:tableName} dq\n  SET\n    total_attempts     = dq.total_attempts + 1,\n    next_delivery_ts   = NULL,\n    is_being_delivered = TRUE,\n    delivery_ts        = :now\n  FROM locked l\n  WHERE dq.id = l.id\n  RETURNING dq.*;\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName), MessageFormatter.NamedArgumentBinding.arg((String)"values", (Object)values.toString())});
        return new BatchedSqlResult(sql, singleValueBindings, listBindings);
    }

    public String getResetMessagesStuckBeingDeliveredSql() {
        return MessageFormatter.bind((String)"UPDATE {:tableName} SET\nis_being_delivered = FALSE,\ndelivery_ts = NULL,\nredelivery_attempts = redelivery_attempts + 1,\nnext_delivery_ts = :now,\nlast_delivery_error = :error\nWHERE is_being_delivered = TRUE\nAND delivery_ts <= :threshold\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getHasOrderedMessageQueuedForKeySql() {
        return MessageFormatter.bind((String)"SELECT count(*) FROM {:tableName}\nWHERE\nqueue_name = :queueName AND\nkey = :key AND\ndelivery_mode = 'IN_ORDER'\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getGetTotalMessagesQueuedForSql() {
        return MessageFormatter.bind((String)"SELECT count(*) FROM {:tableName}\nWHERE\nqueue_name = :queueName AND\nis_dead_letter_message = FALSE\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueuedMessageCountsForSql() {
        return MessageFormatter.bind((String)"SELECT\nCOUNT(*) FILTER (WHERE is_dead_letter_message = FALSE) AS regular_count,\nCOUNT(*) FILTER (WHERE is_dead_letter_message = TRUE) AS dead_letter_count\nFROM {:tableName}\nWHERE\nqueue_name = :queueName\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getGetTotalDeadLetterMessagesQueuedForSql() {
        return MessageFormatter.bind((String)"SELECT count(*) FROM {:tableName}\nWHERE\nqueue_name = :queueName AND\nis_dead_letter_message = TRUE\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getPurgeQueueSql() {
        return MessageFormatter.bind((String)"DELETE FROM {:tableName} WHERE queue_name = :queueName", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueryForMessagesSoonReadyForDeliverySql() {
        return MessageFormatter.bind((String)"SELECT id, added_ts, next_delivery_ts FROM {:tableName}\nWHERE queue_name = :queueName\nAND is_dead_letter_message = FALSE\nAND is_being_delivered = FALSE\nAND next_delivery_ts > :now\nORDER BY next_delivery_ts ASC\nLIMIT :pageSize\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getResetMessagesStuckBeingDeliveredAcrossMultipleQueuesSql() {
        return MessageFormatter.bind((String)"UPDATE {:tableName} SET\nis_being_delivered = FALSE,\ndelivery_ts = NULL,\nredelivery_attempts = redelivery_attempts + 1,\nnext_delivery_ts = :now,\nlast_delivery_error = :error\nWHERE is_being_delivered = TRUE\nAND delivery_ts <= :threshold\nAND queue_name IN (<queueNames>)\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateQueueTableSql() {
        return MessageFormatter.bind((String)"CREATE TABLE IF NOT EXISTS {:tableName} (\nid                     TEXT PRIMARY KEY,\nqueue_name             TEXT NOT NULL,\nmessage_payload        JSONB NOT NULL,\nmessage_payload_type   TEXT NOT NULL,\nadded_ts               TIMESTAMPTZ NOT NULL,\nnext_delivery_ts       TIMESTAMPTZ,\ndelivery_ts            TIMESTAMPTZ DEFAULT NULL,\ntotal_attempts         INTEGER DEFAULT 0,\nredelivery_attempts    INTEGER DEFAULT 0,\nlast_delivery_error    TEXT DEFAULT NULL,\nis_being_delivered     BOOLEAN DEFAULT FALSE,\nis_dead_letter_message BOOLEAN NOT NULL DEFAULT FALSE,\nmeta_data              JSONB DEFAULT NULL,\ndelivery_mode          TEXT NOT NULL,\nkey                    TEXT DEFAULT NULL,\nkey_order              BIGINT DEFAULT -1\n)\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateOrderedMessageIndexSql() {
        return MessageFormatter.bind((String)"CREATE INDEX IF NOT EXISTS idx_{:tableName}_ordered_msg ON {:tableName} (queue_name, key, key_order)", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateNextMessageIndexSql() {
        return MessageFormatter.bind((String)"CREATE INDEX IF NOT EXISTS idx_{:tableName}_next_msg ON {:tableName} (queue_name, is_dead_letter_message, is_being_delivered, next_delivery_ts)", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateNextReadyMessageIndexSql() {
        return MessageFormatter.bind((String)"CREATE INDEX IF NOT EXISTS idx_{:tableName}_ready ON {:tableName} (\n    queue_name,\n    next_delivery_ts,\n    key,\n    key_order\n)\nWHERE\n    is_dead_letter_message = FALSE\n    AND is_being_delivered = FALSE\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateOrderedMessageReadyIndexSql() {
        return MessageFormatter.bind((String)"CREATE INDEX IF NOT EXISTS idx_{:tableName}_ordered_ready\n  ON {:tableName} (key, queue_name, key_order, next_delivery_ts)\n  INCLUDE (id)\n  WHERE key IS NOT NULL\n    AND NOT is_dead_letter_message\n    AND NOT is_being_delivered\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateUnorderedMessageReadyIndexSql() {
        return MessageFormatter.bind((String)"CREATE INDEX IF NOT EXISTS idx_{:tableName}_unordered_ready\n  ON {:tableName} (queue_name, next_delivery_ts)\n  INCLUDE (id)\n  WHERE key IS NULL\n    AND NOT is_dead_letter_message\n    AND NOT is_being_delivered\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getCreateOrderedMessageHeadIndexSql() {
        return MessageFormatter.bind((String)"CREATE INDEX IF NOT EXISTS idx_{:tableName}_ordered_head\n  ON {:tableName} (queue_name, key_order, next_delivery_ts)\n  INCLUDE (id)\n  WHERE key IS NOT NULL\n    AND is_dead_letter_message = FALSE\n    AND is_being_delivered     = FALSE;\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueueNamesSql() {
        return MessageFormatter.bind((String)"SELECT distinct queue_name FROM {:tableName}", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueueMessageSql() {
        return MessageFormatter.bind((String)"INSERT INTO {:tableName} (\nid,\nqueue_name,\nmessage_payload,\nmessage_payload_type,\nadded_ts,\nnext_delivery_ts,\nlast_delivery_error,\nis_dead_letter_message,\nmeta_data,\ndelivery_mode,\nkey,\nkey_order\n) VALUES (\n:id,\n:queueName,\n:message_payload::jsonb,\n:message_payload_type,\n:addedTimestamp,\n:nextDeliveryTimestamp,\n:lastDeliveryError,\n:isDeadLetterMessage,\n:metaData::jsonb,\n:deliveryMode,\n:key,\n:order\n)\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueueMessageSqlOptimized() {
        return MessageFormatter.bind((String)"  INSERT INTO {:tableName} (\n    id, queue_name, message_payload, message_payload_type,\n    added_ts, next_delivery_ts, last_delivery_error,\n    is_dead_letter_message, is_being_delivered,\n    meta_data, delivery_mode, key, key_order\n  )\n  SELECT\n    :id,\n    :queueName,\n    :message_payload::jsonb,\n    :message_payload_type,\n    :addedTimestamp,\n    :nextDeliveryTimestamp,\n    :lastDeliveryError,\n    -- inline dead-letter-barrier check:\n    CASE\n      WHEN :key IS NOT NULL\n        AND EXISTS (\n          SELECT 1\n          FROM {:tableName} dq\n          WHERE dq.queue_name             = :queueName\n            AND dq.key                    = :key\n            AND dq.key_order     < :order\n            AND dq.is_dead_letter_message = TRUE\n        )\n      THEN TRUE\n      ELSE :isDeadLetterMessage\n    END,\n    FALSE,\n    :metaData::jsonb,\n    :deliveryMode,\n    :key,\n    :order\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getRetryMessageSql() {
        return MessageFormatter.bind((String)"UPDATE {:tableName} SET\nnext_delivery_ts = :nextDeliveryTimestamp,\nlast_delivery_error = :lastDeliveryError,\nredelivery_attempts = redelivery_attempts + 1,\nis_being_delivered = FALSE,\ndelivery_ts = NULL\nWHERE id = :id\nRETURNING *\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getMarkAsDeadLetterMessageSql() {
        return MessageFormatter.bind((String)"UPDATE {:tableName} SET\nnext_delivery_ts = NULL,\nlast_delivery_error = :lastDeliveryError,\nis_dead_letter_message = TRUE,\nis_being_delivered = FALSE,\ndelivery_ts = NULL\nWHERE id = :id AND is_dead_letter_message = FALSE\nRETURNING *\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getResurrectDeadLetterMessageSql() {
        return MessageFormatter.bind((String)"UPDATE {:tableName} SET\nnext_delivery_ts = :nextDeliveryTimestamp,\nis_dead_letter_message = FALSE\nWHERE id = :id AND\nis_dead_letter_message = TRUE\nRETURNING *\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getAcknowledgeMessageAsHandledSql() {
        return MessageFormatter.bind((String)"DELETE FROM {:tableName} WHERE id = :id AND is_dead_letter_message = FALSE", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getDeleteMessageSql() {
        return MessageFormatter.bind((String)"DELETE FROM {:tableName} WHERE id = :id", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueueNameForQueueEntryIdSql() {
        return MessageFormatter.bind((String)"SELECT queue_name FROM {:tableName} WHERE id = :queueEntryId", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public String getQueuedMessageByIdSql() {
        return MessageFormatter.bind((String)"SELECT * FROM {:tableName} WHERE\nid = :id AND\nis_dead_letter_message = :isDeadLetterMessage\n", (MessageFormatter.NamedArgumentBinding[])new MessageFormatter.NamedArgumentBinding[]{MessageFormatter.NamedArgumentBinding.arg((String)"tableName", (Object)this.sharedQueueTableName)});
    }

    public static class BatchedSqlResult {
        private final String sql;
        private final Map<String, String> singleValueBindings;
        private final Map<String, Collection<String>> listBindings;

        public BatchedSqlResult(String sql, Map<String, String> singleValueBindings, Map<String, Collection<String>> listBindings) {
            this.sql = sql;
            this.singleValueBindings = singleValueBindings;
            this.listBindings = listBindings;
        }

        public String getSql() {
            return this.sql;
        }

        public Map<String, String> getSingleValueBindings() {
            return this.singleValueBindings;
        }

        public Map<String, Collection<String>> getListBindings() {
            return this.listBindings;
        }
    }
}

