/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.groupsio.api;

import engineer.nightowl.groupsio.api.resource.ArchiveResource;
import engineer.nightowl.groupsio.api.resource.GroupResource;
import engineer.nightowl.groupsio.api.resource.MemberResource;
import engineer.nightowl.groupsio.api.resource.UserResource;
import org.apache.http.HttpHost;
import org.apache.http.util.Asserts;

public class GroupsIOApiClient {
    private final String apiKey;
    private final String email;
    private final String domain;
    private final Integer twoFactor;
    private String apiToken;
    private final String version;
    private final String hostname;
    public static final String DEFAULT_HOSTNAME = "api.groups.io";
    public static final String DEFAULT_SCHEME = "https";
    public static final HttpHost DEFAULT_HOST = new HttpHost("api.groups.io", -1, "https");
    public static final String DEFAULT_API_BASE = DEFAULT_HOST.toURI();
    public static final String DEFAULT_VERSION = "v1";
    public static final String DEFAULT_VERSIONED_API_BASE = DEFAULT_API_BASE + "/" + "v1" + "/";
    public static final String DEFAULT_DOMAIN = "groups.io";

    public GroupsIOApiClient(String apiKey, String email) {
        this(DEFAULT_HOSTNAME, DEFAULT_VERSION, apiKey, email, DEFAULT_DOMAIN, null);
    }

    public GroupsIOApiClient(String hostname, String version, String apiKey, String email, String domain, Integer twoFactor) {
        Asserts.notBlank((CharSequence)apiKey, (String)"apiKey");
        Asserts.notBlank((CharSequence)email, (String)"email");
        this.hostname = hostname;
        this.version = version;
        this.apiKey = apiKey;
        this.email = email;
        this.domain = domain;
        this.twoFactor = twoFactor;
    }

    public UserResource user() {
        return new UserResource(this, DEFAULT_VERSIONED_API_BASE);
    }

    public MemberResource member() {
        return new MemberResource(this, DEFAULT_VERSIONED_API_BASE);
    }

    public GroupResource group() {
        return new GroupResource(this, DEFAULT_VERSIONED_API_BASE);
    }

    public ArchiveResource archive() {
        return new ArchiveResource(this, DEFAULT_VERSIONED_API_BASE);
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getTwoFactor() {
        return this.twoFactor;
    }

    public String getApiToken() {
        return this.apiToken;
    }
}

