/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.groupsio.api.resource;

import engineer.nightowl.groupsio.api.GroupsIOApiClient;
import engineer.nightowl.groupsio.api.domain.Error;
import engineer.nightowl.groupsio.api.domain.Group;
import engineer.nightowl.groupsio.api.domain.Page;
import engineer.nightowl.groupsio.api.domain.Permissions;
import engineer.nightowl.groupsio.api.exception.GroupsIOApiException;
import engineer.nightowl.groupsio.api.exception.GroupsIOApiExceptionType;
import engineer.nightowl.groupsio.api.resource.BaseResource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class GroupResource
extends BaseResource {
    public GroupResource(GroupsIOApiClient apiClient, String baseUrl) {
        super(apiClient, baseUrl);
    }

    public Permissions getPermissions(Integer groupId) throws URISyntaxException, IOException, GroupsIOApiException {
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getperms");
        uri.setParameter("group_id", groupId.toString());
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        return this.callApi((HttpUriRequest)request, Permissions.class);
    }

    public Group getGroup(Integer groupId) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(groupId).getManageGroupSettings().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getgroup");
            uri.setParameter("group_id", groupId.toString());
            HttpGet request = new HttpGet();
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Group.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public List<Group> getSubgroups(Integer groupId) throws URISyntaxException, IOException, GroupsIOApiException {
        URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "getsubgroups");
        uri.setParameter("group_id", groupId.toString());
        uri.setParameter("limit", "100");
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        Page page = this.callApi((HttpUriRequest)request, Page.class);
        List<Object> subgroups = Arrays.asList((Object[])OM.convertValue(page.getData(), Group[].class));
        while (page.getHasMore().booleanValue()) {
            uri.setParameter("page_token", page.getNextPageToken().toString());
            request.setURI(uri.build());
            page = this.callApi((HttpUriRequest)request, Page.class);
            subgroups.addAll(Arrays.asList((Object[])OM.convertValue(page.getData(), Group[].class)));
        }
        return subgroups;
    }

    public void createSubGroup(Integer groupId, String name, String description, String privacy) {
        throw new UnsupportedOperationException("Not implemented in API");
    }

    public Group updateGroup(Group group) throws URISyntaxException, IOException, GroupsIOApiException {
        if (this.apiClient.group().getPermissions(group.getId()).getManageGroupSettings().booleanValue()) {
            URIBuilder uri = new URIBuilder().setPath(this.baseUrl + "updategroup");
            HttpPost request = new HttpPost();
            Map map = (Map)OM.convertValue((Object)group, Map.class);
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            for (Map.Entry entry : map.entrySet()) {
                postParameters.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue().toString()));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
            request.setURI(uri.build());
            return this.callApi((HttpUriRequest)request, Group.class);
        }
        Error error = new Error();
        error.setType(GroupsIOApiExceptionType.INADEQUATE_PERMISSIONS);
        throw new GroupsIOApiException(error);
    }

    public void deleteGroup(Integer groupId) {
        throw new UnsupportedOperationException("Not implemented in API");
    }
}

