/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.groupsio.api.resource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import engineer.nightowl.groupsio.api.GroupsIOApiClient;
import engineer.nightowl.groupsio.api.domain.Error;
import engineer.nightowl.groupsio.api.domain.Login;
import engineer.nightowl.groupsio.api.exception.GroupsIOApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;

public class BaseResource {
    protected final GroupsIOApiClient apiClient;
    protected final String baseUrl;
    protected static final String MAX_RESULTS = "100";
    public static final ObjectMapper OM = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public BaseResource(GroupsIOApiClient client, String baseUrl) {
        this.apiClient = client;
        this.baseUrl = baseUrl;
    }

    public String login(String password) throws URISyntaxException, GroupsIOApiException, IOException {
        URIBuilder uri = new URIBuilder().setPath(GroupsIOApiClient.DEFAULT_VERSIONED_API_BASE + "login");
        uri.setParameter("email", this.apiClient.getEmail());
        uri.setParameter("password", password);
        HttpGet request = new HttpGet();
        request.setURI(uri.build());
        Login login = this.callApi((HttpUriRequest)request, Login.class, true);
        String apiToken = login.getToken();
        this.apiClient.setApiToken(apiToken);
        return apiToken;
    }

    protected <T> T callApi(HttpUriRequest request, Class<T> type) throws IOException, GroupsIOApiException {
        return this.callApi(request, type, false);
    }

    protected <T> T callApi(HttpUriRequest request, Class<T> type, Boolean login) throws IOException, GroupsIOApiException {
        Throwable throwable = null;
        try (CloseableHttpClient client = this.getHttpClient(login, request);){
            T t;
            CloseableHttpResponse response = client.execute(request);
            InputStream stream = response.getEntity().getContent();
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new GroupsIOApiException(this.mapToError(bytes));
            }
            try {
                t = type.cast(OM.readValue(bytes, Class.forName(type.getName())));
            }
            catch (JsonMappingException | ClassNotFoundException jme) {
                try {
                    throw new GroupsIOApiException(this.mapToError(bytes));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return t;
        }
    }

    private Error mapToError(byte[] bytes) throws JsonParseException, JsonMappingException, IOException {
        return (Error)OM.readValue(bytes, Error.class);
    }

    private CloseableHttpClient getHttpClient(Boolean login, HttpUriRequest request) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        String key = login != false ? this.apiClient.getApiKey() : this.apiClient.getApiToken();
        key = key + ":";
        byte[] credentials = Base64.encodeBase64((byte[])key.getBytes(StandardCharsets.UTF_8));
        BasicHeader authHeader = new BasicHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
        request.addHeader((Header)authHeader);
        return builder.build();
    }
}

